from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

utakmice = sc.textFile('./utakmice.csv').mapPartitions(lambda x: csvReader(x, delimiter=';'))
golovi = sc.textFile('./golovi.csv').mapPartitions(lambda x: csvReader(x, delimiter=';'))
timovi = sc.textFile('./timovi.csv').mapPartitions(lambda x: csvReader(x, delimiter=';'))

golovi_t = golovi.map(lambda x: (x[1], (x[0], x[2])))

utakmice_golovi = utakmice.leftOuterJoin(golovi_t).map(lambda x: (x[0], (x[1][0][1], x[1][0][2], 0 if x[1][1][0] is None else 1, x[1][1][1]))).map(lambda x: ((x[0], x[1][3]), x[1][2]))

utakmice_timovi = utakmice_golovi.reduceByKey(lambda x, y: x + y)

res = utakmice_timovi

print(res)

