from pyspark import SparkConf, SparkContext
import csv

def obradi(x):
    id_utakmice, domacin, gost, id_tima, br_golova = x
    rezultati []

    if(id_tima == domacin):
        rezultati.append(id_utakmice, (domacin, gost), golovi, 0)
    if(id_tima == gost):
        rezultati.append(id_utakmice, (domacin, gost), 0, golovi)

    return rezultati


#def obradiRezultate(x):
#    id_utakmice, (domacin, gost), golovi_domacin, golovi_gost = x
#    rezultati []
#
#    if(id_tima == domacin):
#        rezultati.append(id_utakmice, (domacin, gost), golovi, 0)
#    if(id_tima == gost):
#        rezultati.append(id_utakmice, (domacin, gost), 0, golovi)
#
#    return rezultati

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

utakmice=sc.textFile("utakmice.csv").mapPartitions(lambda x: csv.reader(x)).map(lambda x: (x[0], (x[2], x[3])))
#(id_utakmice, (id_domacin, id_gost))


golovi=sc.textFile("golovi.csv").mapPartitions(lambda x: csv.reader(x)).map(lambda x: ((x[1], x[2]), 1))

#((id_utakmice, id_tima), 1)

#((1, czv), 1)
#((1, czv), 1)
#((1, par), 1)
#((1, par), 1)
#((1, par), 1)

golovi.reduceByKey(lambda a,b: a[1]+b[1])
#((id_utakmice, id_tima), br_golova)
#((1, czv), 2)
#((1, par), 3)

golovi.map(lambda x: x[0][0], (x[0][1],x[1]))
#(id_utakmice, (id_tima, br_golova))

utakmice.join(golovi)

#(id_utakmice(
#               (id_domacin, id_gost),
#               (id_tima, br_golova),
#            )

utakmice.flatMap(obradi)
#(id_utakmice, domacin, gost, id_tima, br_golova)
#(1, czv, par, czv, 2)
#(1, czv, par, par, 3)
#nakon obrade
#(id_utakmice, (czv, par), 2, 0)
#(id_utakmice, (czv, par), 0, 3)


rezultati_utakmica=utakmice.reduceByKey(lambda a, b: a[2] + b[2], a[3] + b[3])
#izgled:
#(id_utakmice, (id_domacin, id_gost), golovi_domacin, golovi_gost)
#(id_utakmice, (czv, par), 2, 3)
#(id_utakmice, (czv, rad), 5, 1)
#(id_utakmice, (rad, czv), 2, 3)

# if(x[0][0] == x[0][1] and x[0][1] == x[0][0])
# map(lambda x: x[0][1], x[0][0], x[2], x[1])

#rezultati_utakmica.map(lambda x: (x[0][0], x[0][1]), 1: x[1] > x[2] )

#rezultati_utakmica.map(lambda x: x[1], x[2], x[3], x[0])

najbolji=rezultati_utakmica.reduceByKey(lambda a,b: a[0] < b[0] 
                                        and ((a[1][0] == b[1][0] and a[1][1] == b[1][1]) or (a[1][0] == b[1][1] and a[1][1] == b[1][0]))
                                        and (a[2] > a[3]))


timovi=sc.textFile("timovi.csv").mapPartitions(lambda x: csv.reader(x)).map(lambda x: x[0], x[1])
timovi.join(najbolji)
