#!/bin/bash

rm -f *.in
rm -f *.out
rm -f slurm-*
rm -f input_*
rm -rf task
rm -f najduza_serija_po_timu.csv
rm -f rezultat.txt

dos2unix -q *.csv
dos2unix -q run.sh
dos2unix -q job.slurm

# awk -F ';' '{print $1}' timovi.csv | sort -u | split -l 1 - input_
awk -F ';' '{print $1}' timovi.csv | split -l 1 - input_

i=1
for file in input_*
do
	mv "$file" "$i.in"
	((i++))
done

((i--))

gcc -std=c99 task.c -o task
chmod +x task

job=`sbatch --array=1-$i job.slurm | awk '{print $4}'`

while squeue -j $job -h | grep -q .
do
	sleep 1
done

touch najduza_serija_po_timu.csv
cat *.out > najduza_serija_po_timu.csv

max_serija=`awk -F ';' '$2 > max {max = $2} END {print max}' najduza_serija_po_timu.csv`

touch rezultat.txt
awk -F ';' -v max=$max_serija '$2 == max {print}' najduza_serija_po_timu.csv > rezultat.txt