#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <stdbool.h>
#include <stdlib.h>

#define MAX_TIMOVA 1000
#define MIN_ID 1

bool pobedio(int id_tima, int id_protivnika, int id_utakmice)
{
	FILE* golovi_file = fopen("golovi.csv", "r");
	assert(golovi_file);

	int golovi_tima = 0;
	int golovi_protivnika = 0;

	int it_id_gola, it_id_utakmice, it_id_tima, it_id_igraca;
	while(fscanf(golovi_file, "%d;%d;%d;%d", &it_id_gola, &it_id_utakmice, &it_id_tima, &it_id_igraca) == 4)
	{
		if(id_utakmice == it_id_utakmice)
		{
			if(it_id_tima == id_tima)
				golovi_tima++;
			else if(it_id_tima == id_protivnika)
				golovi_protivnika++;
		}
	}

	fclose(golovi_file);

	return (golovi_tima > golovi_protivnika);
}

int main(int argc, char** argv)
{
	assert(argc > 1);

	int id_tima;
	int status;
	int i;
	int* brojaci = malloc(sizeof(int) * MAX_TIMOVA);
	// int broj_timova = 0;
	assert(brojaci);

	memset(brojaci, 0, sizeof(int) * MAX_TIMOVA);

	// Nadji id

	FILE* f = fopen(argv[1], "r");
	assert(f);

	id_tima = 0;
	status = fscanf(f, "%d", &id_tima);
	assert(status == 1);

	fclose(f);

	FILE* utakmice_file = fopen("utakmice.csv", "r");
	assert(utakmice_file);

	// Za svaku utakmicu proveri da li je tim pobedio

	int it_id_utakmice, it_id_sezone, it_id_domacina, it_id_gosta;
	while(fscanf(utakmice_file, "%d;%d;%d;%d", &it_id_utakmice, &it_id_sezone, &it_id_domacina, &it_id_gosta) == 4)
	{
		// Pretpostavka: utakmice su u tabeli sortirane hronoloski - utakmica sa id=x je igrana posle x-1
		if(it_id_domacina == id_tima) // tim je igrao kao domacin
		{
			if(pobedio(id_tima, it_id_gosta, it_id_utakmice))
				brojaci[it_id_gosta]++;
		}
		else if(it_id_gosta == id_tima) // tim je igrao kao gost
		{
			if(pobedio(id_tima, it_id_domacina, it_id_utakmice))
				brojaci[it_id_domacina]++;
		}
		else {} // tim nije igrao
	}

	fclose(utakmice_file);

	int max = -1;
	int max_id = -1;
	for(i = MIN_ID; i < MAX_TIMOVA; i++)
	{
		if(brojaci[i] > max)
		{
			max = brojaci[i];
			max_id = i;
		}
	}

	free(brojaci);

	// Nije bitno protiv koga
	printf("%d;%d\n", id_tima, max);
	
	return 0;
}
