from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)


utakmice = sc.textFile("utakmice.csv")

utakmice = utakmice.map(lambda x: x.split(";"))
utakmice = utakmice.map(lambda x: (x[0],(x[2],x[3])))

golovi = sc.textFile("golovi.csv")

golovi = golovi.map(lambda x: x.split(";"))

golovi = golovi.map(lambda x: (x[1],x[2]))




golovi_utakmice = golovi.join(utakmice)

golovi_utakmice = golovi_utakmice.map(lambda x:(x[0],(x[1][0],x[1][1][0],x[1][1][1])))

golovi_utakmice_domacin = golovi_utakmice.map(lambda x:(x[0],x[1][0],x[1][1]))

golovi_utakmice_domacin = golovi_utakmice_domacin.filter(lambda x: x[1] == x[2])
golovi_utakmice_domacin = golovi_utakmice_domacin.map(lambda x: ((x[0],x[1]),1))

golovi_utakmice_domacin = golovi_utakmice_domacin.reduceByKey(lambda x,y: x+y)

golovi_utakmice_domacin = golovi_utakmice_domacin.map(lambda x: (x[0][0],(x[0][1],x[1])))
#ovde dobijamo koliko je koji tim dao golova kao domacin i na kojoj utakmici

golovi_utakmice_gost = golovi_utakmice.map(lambda x:(x[0],x[1][0],x[1][2]))

golovi_utakmice_gost = golovi_utakmice_gost.filter(lambda x: x[1] == x[2])
golovi_utakmice_gost = golovi_utakmice_gost.map(lambda x: ((x[0],x[1]),1))

golovi_utakmice_gost = golovi_utakmice_gost.reduceByKey(lambda x,y: x+y)

golovi_utakmice_gost = golovi_utakmice_gost.map(lambda x: (x[0][0],(x[0][1],x[1])))
#ovde dobijamo koliko je koji tim dao golova kao gost i na kojoj utakmici

utakmice_rezultat = golovi_utakmice_domacin.join(golovi_utakmice_gost)

utakmice_rezultat = utakmice_rezultat.map(lambda x:(x[0],(x[1][0][0],x[1][1][0]),(x[1][0][1],x[1][1][1])))
#ovime dobijamo format (id_utakmice,(ko_igra),(rezultat))

pobednik = utakmice_rezultat.map(lambda x: (x[0],(x[1][0],x[1][1]),(x[2][0] - x[2][1])))


#ako je broj pozitivan to znaci da je domacin pobedio ako je broj negativan to znaci da je gost pobedio nereseno nam nije bitno jer ono svakako zustavlja niz pobeda

pobednik_gost = pobednik.filter(lambda x: x[2] < 0)

pobednik_gost = pobednik_gost.map(lambda x: (x[0],x[1][1]))


pobednik_domacin = pobednik.filter(lambda x: x[2] > 0)
pobednik_domacin = pobednik_domacin.map(lambda x: (x[0],x[1][0]))

#print(pobednik_domacin.collect())

#ovde se nalaze svi pobednici 
pobednici = pobednik_domacin.fullOuterJoin(pobednik_gost)


#print(pobednici.collect())

print(utakmice.collect())

utakmice_sa_pobendikom=utakmice.fullOuterJoin(pobednici)
print(utakmice_sa_pobendikom.collect())

sc.stop()

