from pyspark import SparkConf, SparkContext
conf = SparkConf().setMaster("local").setAppName("Stanislav")
sc = SparkContext(conf = conf)

def vrednostGola(id_domacina, id_gosta, id_tima):
    if id_tima == id_domacina:
        return 1
    elif id_tima == id_gosta:
        return -1
    return 0

import csv
def loadCsv(row):
    return csv.reader(row, delimiter=';')

utakmice = sc.textFile("../utakmice.csv").persist().mapPartitions(lambda x: loadCsv(x))
golovi = sc.textFile("../golovi.csv").persist().mapPartitions(lambda x: loadCsv(x))
timovi = sc.textFile("../timovi.csv").persist().mapPartitions(lambda x: loadCsv(x))

utakmice = utakmice.map(lambda x: (x[0], x[1:]))

# [(idUtakmice, [id_sezone, id_domacina, id_gosta], id_tima), ...]
# [(idUtakmice, ([id_sezone, id_domacina, id_gosta], 1)), ...]
# [(idUtakmice, ([id_sezone, id_domacina, id_gosta], koloko_domacin_vodi)), ...]
# [(idUtakmice, ([id_sezone, id_domacina, id_gosta], True)), ...]
domacin_pobedio = utakmice.join(golovi.map(lambda x: (x[1], x[2]))) \
                    .map(lambda x: (x[0], (x[1][0], vrednostGola(x[1][0][1], x[1][0][2], x[1][1])))) \
                    .reduceByKey(lambda x, y: (x[0], x[1] + y[1])) \
                    .map(lambda x: (x[0], (x[1][0], x[1][1] > 0)))

# [(id_sezone, (id_pobednika, id_gubitnika)), ...]
# [(id_sezone, (id_pobednika, id_gubitnika)), ...]
# [(id_sezone, [(id_pobednika, id_gubitnika)), ...], ...]
gubitnici = domacin_pobedio.map(lambda x: (x[1][0][0], x[1][0][1] if x[1][1] else x[1][0][2], x[1][0][2] if x[1][1] else x[1][0][1])) \
                .sortByKey() \
                .reduceByKey(lambda x, y: (list(x) + list(y)))

