from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)

def najduzaSerija(utakmice):
    najduza = 0
    for u1 in utakmice:
        trenutna = 0
        for u2 in utakmice:
            if(u1[1] == u2[1]):
                if(u1[2] == True and u2[2] == True):
                    trenutna = trenutna + 1
                elif(u1[2] == True and u2[2] == False):
                    break
        if(trenutna > najduza):
            najduza = trenutna
    return najduza

# ((idUtakmice, idTima), 0)
goloviDomacinPocetni = sc.textFile("./Ulaz/utakmice.csv").mapPartitions(lambda x : csv.reader(x, delimiter = ";")).map(lambda x : ((x[0], x[2]), 0))
goloviGostPocetni = sc.textFile("./Ulaz/utakmice.csv").mapPartitions(lambda x : csv.reader(x, delimiter = ";")).map(lambda x : ((x[0], x[3]), 0))

goloviPocetni = goloviDomacinPocetni.union(goloviGostPocetni)

# ((idUtakmice, idTima), brGolova)
golovi = sc.textFile("./Ulaz/golovi.csv").mapPartitions(lambda x : csv.reader(x, delimiter = ";")).map(lambda x : ((x[1], x[2]), 1))
golovi = golovi.union(goloviPocetni)
golovi = golovi.reduceByKey(lambda x, y: x + y)

# (idUtakmice, (idTima, brGolova))
golovi = golovi.map(lambda x : (x[0][0], (x[0][1], x[1])))

# (idUtakmice, (idTima, brGolova, idTima, brGolova))
utakmice = golovi.reduceByKey(lambda x , y : (x[0], x[1], y[0], y[1]))

# print("===========================================")
# print(" UTAKMICE: ")
# print("===========================================")
# for x in utakmice.collect():
#     print(x)
# print("===========================================")

# (idTima, [(idUtakmice, idTima, pobeda?)])
pobedeDomacin = utakmice.map(lambda x : (x[1][0], [(x[0], x[1][2], True if x[1][1] - x[1][3] > 0 else False)]))
pobedeGost = utakmice.map(lambda x : (x[1][2], [(x[0], x[1][0], True if x[1][3] - x[1][1] > 0 else False)]))

pobede = pobedeDomacin.union(pobedeGost)

# (idTima, [(idUtakmice, idTima, pobeda?)....])
pobedePoTimovima = pobede.reduceByKey(lambda x, y : x + y)

# (idTima, [(idUtakmice, idTima, pobeda?)....]) sortirano po idUtakmice
pobedePoTimovima = pobedePoTimovima.map(lambda x : (x[0], sorted(x[1])))

# (idTima, najduzaSerija)
pobedePoTimovima = pobedePoTimovima.map(lambda x : (x[0], najduzaSerija(x[1])))

pobedePoTimovima = pobedePoTimovima.map(lambda x : (x[1], x[0])).reduceByKey(lambda x, y : x)
pobedePoTimovima = pobedePoTimovima.sortByKey(ascending = False)

print(pobedePoTimovima.top(1))

# print("===========================================")
# for x in pobedePoTimovima.collect():
#     print(x)
# print("===========================================")

# help(pobedePoTimovima)