from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("SparkKolokvijum")
sc = SparkContext(conf = conf)


golovi=sc.textFile("golovi.csv").map(lambda x:x.split())

utakmice=sc.textFile("utakmice.csv").map(lambda x:x.split())

timovi=sc.textFile("timovi.csv").map(lambda x:x.split())

golovi=golovi.map(lambda x:((x[1],x[2]),1)) # ((id_utakmice,id_tima),1) - svaki red je jedan gol

timovi=timovi.map(lambda x:(x[0],x[1])) # (id_tima,naziv)

utakmice=utakmice.map(lambda x:(x[0],(x[2],x[3]))) # (id_utakmice,(id_domacina,id_gosta))

golovi=golovi.reduceByKey(lambda a,b:a+b)

golovi=golovi.map(lambda x:(x[0],(x[1],x[2]))) # (id_utakmice,(id_tima,postignuti_golovi))

utakmice_golovi=utakmice.join(golovi) # (id_utakmice,((id_domacina,id_gosta),(id_tima,postignuti_golovi)))

golovi_domacina=utakmice_golovi.map(lambda x:(x[0],(x[1][0],x[2][1],x[2][2]))) # (id_utakmice,(id_domacina,id_tima,postignuti_golovi))

golovi_domacina=golovi_domacina.filter(lambda x:x[1][0]==x[2][1]) #filtrirano 

golovi_domacina=golovi_domacina.map(lambda x:(x[0],(x[1][1],x[1][2]]))) # (id_utakmice,(id_tima,postignuti_golovi)) golovi domacina za svaku utakmicu

golovi_gosta=utakmice_golovi.map(lambda x:(x[0],(x[1][1],x[2][1],x[2][2]))) # (id_utakmice,(id_domacina,id_tima,postignuti_golovi))

golovi_gosta=golovi_gosta.filter(lambda x:x[1][1]==x[2][1]) #filtrirano

golovi_gosta=golovi_gosta.map(lambda x:(x[0],(x[1][1],x[1][2]))) # (id_utakmice,(id_tima,postignuti_golovi)) golovi gosta na svakoj utakmici

golovi_utakmice=golovi_domacina.join(golovi_gosta) # (id_utakmice,((id_domacina,postignuti_golovi),(id_gosta,postignuti_golovi)))

#pobednici na svakoj utakmici
pobednici=golovi_utakmice.map(lambda x:(x[0],(x[1][0][0],x[1][1][0],1 if int(x[1][0][1])>int(x[1][1][1] else 0 if int(x[1][0][1])==int(x[1][1][1]) else 2)))) # (id_utakmice,(id_domacina,id_gosta,pobednik))

pobednici=pobednici.reduceByKey(lambda a,b,c:if a==a and b==b:a+b)

print(pobednici.collect())