#include <stdio.h>
#include <stdlib.h>

typedef struct
{
    int id_sezone;
    int gol_razlika;
} Sezona;

int main(int argc, char *argv[])
{
    if (argc != 2)
    {
        perror("Greksa: argc");
        exit(1);
    }

    int id_tima = atoi(argv[1]);

    FILE* utakmice = fopen("utakmice.csv", "r");

    int utakmice_id;
    int utakmice_id_sezone;
    int utakmice_id_domacina;
    int utakmice_id_gosta;

    int golovi_id;
    int golovi_id_utakmice;
    int golovi_id_tima;
    int golovi_id_igraca;
    
    int gol_razlika;

    int broj_sezona = 0;
    Sezona sezone_gol_razlike[30];

    while (fscanf(utakmice, "%d;%d;%d;%d", &utakmice_id, &utakmice_id_sezone, &utakmice_id_domacina, &utakmice_id_gosta) == 4)
    {
        gol_razlika = 0;

        if (id_tima == utakmice_id_domacina) // TIM JE DOMACIN
        {
            FILE* golovi = fopen("golovi.csv", "r");

            while (fscanf(golovi, "%d;%d;%d;%d", &golovi_id, &golovi_id_utakmice, &golovi_id_tima, &golovi_id_igraca) == 4)
            {
                if (utakmice_id == golovi_id_utakmice)
                {
                    if (utakmice_id_domacina == golovi_id_tima) gol_razlika++;
                    else gol_razlika--;
                }
            }

            fclose(golovi);
        }
        else if (id_tima == utakmice_id_gosta) // TIM JE GOST
        {
            FILE* golovi = fopen("golovi.csv", "r");

            while (fscanf(golovi, "%d;%d;%d;%d", &golovi_id, &golovi_id_utakmice, &golovi_id_tima, &golovi_id_igraca) == 4)
            {
                if (utakmice_id == golovi_id_utakmice)
                {
                    if (utakmice_id_gosta == golovi_id_tima) gol_razlika++;
                    else gol_razlika--;
                }
            }

            fclose(golovi);
        }

        int postoji = 0;
        for (int i = 0; i < broj_sezona; i++)
            if (utakmice_id_sezone == sezone_gol_razlike[i].id_sezone)
            {
                postoji = 1;
                break;
            }

        if (postoji)
            sezone_gol_razlike[i].gol_razlika += gol_razlika;
        else
        {
            sezone_gol_razlike[i].gol_razlika = gol_razlika;
            broj_sezona++;
        }
    }

    fclose(utakmice);

    for (int i = 0; i < broj_sezona; i++)
        printf("%d,%d,%d\n", id_tima, sezone_gol_razlike[i].id_sezone, sezone_gol_razlike[i].gol_razlika);

    return 0;
}