#!/bin/bash

NUM_OF_TEAMS=$(wc -l < timovi.txt)

gcc -std=c99 -o obrada obrada.c
chmod +x obrada

JOB_ID=$(sbatch --array=1-$NUM_OF_TEAMS posao.slurm | awk '{print $4}')
echo "Poslat posao $JOB_ID"

while squeue -j $JOB_ID -h | grep -q .
do
    sleep 2
done

echo "Svi poslovi su zavrseni"

cat *.out > rezultati.txt

echo "Rezultat se nalazi u fajlu rezultati.txt"