from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

golovi = sc.textFile("golovi.csv").map(lambda x: tuple(x.split(";")))
utakmice = sc.textFile("utakmice.csv").map(lambda x: tuple(x.split(";")))
sezone = sc.textFile("sezona.csv").map(lambda x: tuple(x.split(";")))
timovi = sc.textFile("timovi.csv").map(lambda x: tuple(x.split(";")))

timDomacinUtakmice = timovi.join(utakmice.map(lambda x: (x[2], (x[0], x[1], x[3])))).mapValues(lambda x: x[1][0]).reduceByKey(lambda x,y: tuple(list(x) + list(y)))
timGostUtakmice = timovi.join(utakmice.map(lambda x: (x[3], (x[0], x[1], x[2])))).mapValues(lambda x: x[1][0]).reduceByKey(lambda x,y: tuple(list(x) + list(y)))

def prek(x):
    rez = []
    for u in x[1]:
        rez.append(((x[0], u), 1))

    return tuple(rez)
timDomacinUtakmice = timDomacinUtakmice.flatMap(lambda x: prek(x))
timGostUtakmice = timGostUtakmice.flatMap(lambda x: prek(x))

timPoUtakmicamaGolovi = golovi.map(lambda x: ((x[2], x[1]),0))

timDomacinUtkamicaBrojGolova = timDomacinUtakmice.join(timPoUtakmicamaGolovi).reduceByKey(lambda x,y : x[0] + y[0])

timGostUtkamicaBrojGolova = timGostUtakmice.join(timPoUtakmicamaGolovi).reduceByKey(lambda x,y : x[0] + y[0])

timDomacinUkupnoGolova = timDomacinUtkamicaBrojGolova.map(lambda x: (x[0][0], x[1])).reduceByKey(lambda x,y : x + y)
timGostUkupnoGolova = timGostUtkamicaBrojGolova.map(lambda x: (x[0][0], x[1])).reduceByKey(lambda x,y : x + y)

print(timGostUkupnoGolova.collect())
print(timDomacinUkupnoGolova.collect())