from pyspark import SparkConf, SparkContext
import os
import sys
import datetime
#Исписати за сваки тим његову најуспешнију сезону у односу на гол разлику у гостима и код куће.

def readCsv(path):
    data = sc.textFile(path).map(lambda line: line.split(";"))
    return data

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

golovi = readCsv('./golovi.csv')
utakmice = readCsv('./utakmice.csv')
sezone = readCsv('./sezona.csv')

# (id_tima, 1)
go_na_utakmici = golovi.map(lambda x: (int(x[2]), 1))

#(id_domacina, (sezona_id, 0))
domacini = utakmice.map(lambda x: (int(x[2]),(int(x[1]),0)))
#(id_gosta,(sezona_id,0))
gosti = utakmice.map(lambda x: (int(x[3]),(int(x[1]),0)))
#(id_sezone,godina)
sezone_tuple = sezone.map(lambda x: (int(x[0]), int(x[1])))

#((id_tima,id_sezone), 1)
golovi_domacina = domacini.join(go_na_utakmici).map(lambda x: ((x[0],x[1][0][0]), x[1][0][1] + x[1][1]))
preracunati_golovi_domacina_po_sezonama = golovi_domacina.reduceByKey(lambda x,y: x + y) 

golovi_gosta = gosti.join(go_na_utakmici).map(lambda x: ((x[0],x[1][0][0]), x[1][0][1] + x[1][1]))
preracunati_golovi_gosta_po_sezonama = golovi_gosta.reduceByKey(lambda x,y: x + y) 



gol_razlika_tima_po_sezoni = preracunati_golovi_domacina_po_sezonama.join(preracunati_golovi_gosta_po_sezonama).map(lambda x: (x[0],x[1][0] - x[1][1]))
max_gol_razlika = gol_razlika_tima_po_sezoni.filter(lambda x: max(x[1]))
        
#((id_tima,id_sezone), gol_razlika)
print(gol_razlika_tima_po_sezoni.collect())
