from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

def loadRDD(filename):
    return sc.textFile(filename).mapPartitions(lambda x: csv.reader(x, delimiter=';'))

utakmice = loadRDD('Ulaz/utakmice.csv')
golovi = loadRDD('Ulaz/golovi.csv')
sezone = loadRDD('Ulaz/sezona.csv')
timovi = loadRDD('Ulaz/timovi.csv')

odigrane_utakmice = utakmice.map(lambda x: (x[0], (x[1], x[2], x[3]))) # id_utakmice, id_sezone, id_domacina, id_gosta
postignuti_golovi = golovi.map(lambda x: (x[1], (x[2], 1))) # id_utakmice, id_tima, gol
utakmice_golovi = odigrane_utakmice.join(postignuti_golovi) # ('1', (('1', '1', '2'), ('1', 1))) id_utakmice (id_sezone, id_domacina, id_gosta), (tim_id, gol)
postignuti_golovi = utakmice_golovi.filter(lambda x: x[1][0][1] == x[1][1][0] or x[1][0][2] == x[1][1][0]).map(lambda x: ((x[1][0][0], x[1][1][0]), x[1][1][1]))
primljeni_golovi = utakmice_golovi.filter(lambda x: x[1][0][1] == x[1][1][0] or x[1][0][2] == x[1][1][0]).map(lambda x: ((x[1][0][0], x[1][0][1] if x[1][0][1] != x[1][1][0] else x[1][0][2]), x[1][1][1]))

# primljeni/postignuti golovi - (id_sezone, id_tima), gol

ukupno_postignuti_golovi_po_sezoni = postignuti_golovi.reduceByKey(lambda x, y: x + y)
ukupno_primljeni_golovi_po_sezoni = primljeni_golovi.reduceByKey(lambda x, y: x + y)

gol_razlika_tim_sezona = ukupno_postignuti_golovi_po_sezoni.join(ukupno_primljeni_golovi_po_sezoni).map(lambda x: (x[0][1], (x[0][0], x[1][0] - x[1][1]))) #id tima, id_sezone, gol_razlika

najuspesnija_sezona_tim = gol_razlika_tim_sezona.reduceByKey(lambda x, y: x if x[1][1] > y[1][1] else y)

naziv_tima = najuspesnija_sezona_tim.join(timovi).map(lambda x: (x[1][0][0], (x[1][0][1], x[1][1])))

rezultat = naziv_tima.join(sezone).map(lambda x: x[1])

print(rezultat.collect())