from pyspark import SparkConf, SparkContext
import os
import sys
import datetime
import csv
conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

def readCSV(path):
    data = sc.textFile(path).mapPartitions(lambda x: csv.reader(x, delimiter = ';'))
    return data

#golovi[id, id_utakmice, id_tima, id_igraca]
golovi = readCSV('./golovi.csv')
#utakmice[id, id_sezone, id_domaćina, id_gosta]
utakmice = readCSV('./utakmice.csv')
#sezone[id, godina]
sezone = readCSV('./sezona.csv')
#timovi[id, naziv]
timovi = readCSV('./timovi.csv')

#golovi(id_utakmice, (id, id_tima, id_igraca))
golovi = golovi.map(lambda x: (x[1],(x[0], x[2], x[3])))
#utakmice(id, (id_sezone, id_domaćina, id_gosta))
utakmice = utakmice.map(lambda x: (x[0],(x[1], x[2], x[3])))

#posle joina (id_utakmice, ((id_gola, id_tima, id_igraca),(id_sezone, id_domaćina, id_gosta)))
domaci = utakmice.join(golovi).filter(lambda x: x[1][0][1] == x[1][1][1])
#(id_tima, brGolovaD)
domaci_golovi = domaci.map(lambda x: (x[1][0][1], 1)).reduceByKey(lambda x, y: x + y)

#posle joina (id_utakmice, ((id_gola, id_tima, id_igraca),(id_sezone, id_domaćina, id_gosta)))
gosti = utakmice.join(golovi).filter(lambda x: x[1][0][1] == x[1][1][1])
#(id_tima, brGolovaG)
gosti_golovi = domaci.map(lambda x: (x[1][0][1], 1)).reduceByKey(lambda x, y: x + y)




#posle joina (id_tima, (brGolovaD, brGolovaG))
gosti_vise = domaci_golovi.fullOuterJoin(gosti_golovi).map(lambda x: (x[0], (x[1][0] or 0, x[1][1] or 0))).filter(lambda x: x[1][0] > x[1][1])

gosti_vise = gosti_vise.map(lambda x: (x[0], x[1][1])) #(id_tima, brGolovaG)


#timovi = timovi.map(lambda x: )

#rez.saveAsTextFile('resenje.csv')

#print(golovi.collect())
print(domaci_golovi.take(10))