from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

sc.setLogLevel("error")

utakmice = sc.textFile("utakmice.csv").mapPartitions(lambda x: csv.reader(x)).map(lambda x: (x[0].split(";")[0], (x[0].split(";")[1], x[0].split(";")[2], x[0].split(";")[3]))).partitionBy(sc.defaultParallelism)

golovi = sc.textFile("golovi.csv").mapPartitions(lambda x: csv.reader(x)).map(lambda x: ((x[0].split(";")[1], x[0].split(";")[2]), (x[0].split(";")[3], x[0].split(";")[0])))

timovi = sc.textFile("timovi.csv").mapPartitions(lambda x: csv.reader(x)).map(lambda x: ((x[0].split(";")[0], x[0].split(";")[1]))).partitionBy(sc.defaultParallelism)

sezona = sc.textFile("sezona.csv").mapPartitions(lambda x: csv.reader(x)).map(lambda x: ((x[0].split(";")[0], x[0].split(";")[1]))).partitionBy(sc.defaultParallelism)

brojDatihGolovaPoUtakmici = golovi.map(lambda x:
    ((x[0][0], x[0][1]), 1)
).reduceByKey(lambda x, y:
    x + y
).map(lambda x:
    (x[0][0], (x[0][1], x[1]))
).partitionBy(sc.defaultParallelism).persist()

golrazlika = brojDatihGolovaPoUtakmici.join(brojDatihGolovaPoUtakmici).filter(lambda x:
    (x[1][0][0] != x[1][1][0])
).map(lambda x:
    (x[0], (x[1][0][0], x[1][0][1] - x[1][1][1]))
).join(utakmice).map(lambda x:
    (x[1][0][0], (x[1][1][0], x[1][0][1]))
).reduceByKey(lambda x, y:
    x if x[1] > y[1] else y
).map(lambda x:
    (x[1][0], (x[0], x[1][1]))
).join(sezona).map(lambda x:
    (x[1][0][0], (x[1][1], x[1][0][1]))
).rightOuterJoin(timovi).map(lambda x:
    (x[1][1], x[1][0])
).persist()

# .join(timovi).map(lambda x:
#     (x[1][0][0], (x[1][1], x[1][0][1]))
# ).join(sezona).map(lambda x:
#     ((x[1][0][0], x[1][1]), x[1][0][1])
# )

# ispis u formatu (Naziv tima, (sezona, gol razlika))
print(golrazlika.collect())
golrazlika.saveAsTextFile("./najuspesnijaSezonaPoTimovima")

# najbolje pokrenuti sa rm -r najuspesnijaSezonaPoTimovima/ ; spark-submit ./template.py