from pyspark import SparkConf, SparkContext
import csv
import os, shutil
from operator import add

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

# (idTima, naziv)
timovi = sc.textFile("Ulaz/timovi.csv") \
    .mapPartitions(lambda x: csv.reader(x, delimiter=';')) \
    .map(lambda x: (x[0], x[1]))

# (idUtakmice, (idSezone, idDomacina, idGosta))
utakmice = sc.textFile("Ulaz/utakmice.csv") \
    .mapPartitions(lambda x: csv.reader(x, delimiter=';')) \
    .map(lambda x: (x[0], (x[1], x[2], x[3])))

# (id, (idUtakmice, idTima))
golovi = sc.textFile("Ulaz/golovi.csv") \
    .mapPartitions(lambda x: csv.reader(x, delimiter=';')) \
    .map(lambda x: (x[0], (x[1], x[2])))

# (id, godina)
sezona = sc.textFile("Ulaz/sezona.csv") \
    .mapPartitions(lambda x: csv.reader(x, delimiter=';')) \
    .map(lambda x: (x[0], x[1]))

# (idUtakmice, (idDomacin, golovi))
golovi_mapped = golovi \
    .map(lambda x: ((x[1][0], x[1][1]), x[0]))

# (idDomacina, (sezona, ukupan_broj_golova))
golovi_domacin = utakmice \
    .map(lambda x: ((x[0], x[1][1]), x[1][0])) \
    .join(golovi_mapped) \
    .map(lambda x: ((x[1][0], x[0][0], x[0][1]), int(1))) \
    .reduceByKey(add) \
    .map(lambda x: (x[0][2], (x[0][1], x[1])))

# (idGosta, (sezona, ukupan_broj_golova ))
golovi_gost = utakmice \
    .map(lambda x: ((x[0], x[1][2]), x[1][0])) \
    .join(golovi_mapped) \
    .map(lambda x: ((x[1][0], x[0][0], x[0][1]), int(1))) \
    .reduceByKey(add) \
    .map(lambda x: (x[0][2], (x[0][1], x[1])))

golovi_domacin_po_sezoni = timovi \
    .join(golovi_domacin) \
    .map(lambda x: (x[1][0], x[1][1]))

golovi_gost_po_sezoni = timovi \
    .join(golovi_gost) \
    .map(lambda x: (x[1][0], x[1][1]))

for r in golovi_domacin_po_sezoni.take(20):
    print(r)
    
for r in golovi_gost_po_sezoni.take(20):
    print(r)

if os.path.exists("rezultat"):
    shutil.rmtree("rezultat")



sc.stop()