from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

def readCsv(path):
    return sc.textFile(path).mapPartitions(lambda x: csv.reader(x))

timovi = readCsv("timovi.csv").partitionBy(4).persist()
utakmice = readCsv("utakmice.csv")
golovi = readCsv("golovi.csv")
sezone = readCsv("sezone.csv")

golPoUtakmici = golovi.map(lambda _, id_utakmice, id_tima, _: (id_tima, id_utakmice))
utakmicaPoSezoni = utakmice.map(lambda id, id_sezone, _, _: (id_sezone, id))

vrednostGola = golPoUtakmici.goupBy(lambda id_tima, id_utakmice: id_tima)

utakmicaPoSezoni = utakmice.groupBy(lambda id, id_sezone, id_domacina, id_gosta: id_sezone)

# print(timovi.collect())