#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct {
    int sezona;
    int golovi;
} Uspeh;

typedef struct {
    int id;
    char *naziv;
} Tim;

int main(int argc, char **argv){
    if(argc > 2) return 1;
    
    int posao = atoi(argv[1]);
    if(posao < 1 || posao > 4) return 1;
    
    Tim *timovi = malloc(sizeof(Tim) * 100);
    Uspeh *uspeh;
    
    FILE *t = fopen("timovi.csv", "r");
    int broj_timova = 0;
    while(fscanf(t, "%d;%s", timovi->id, timovi->naziv)) broj_timova++; // sakupim sve timove
    fclose(t);

    int broj_ucesca = 0;
    for(int i = 0; i < broj_timova; i++){ 
        if(i != posao) continue;

        FILE *s = fopen("sezona.csv", "r");
        int id_sez, godina;
        int j = 0, broj_golova = 0;
        while(fscanf(s, "%d;%d", &id_sez, &godina)){
            FILE *u = fopen("utakmice.csv", "r");
            int id_utak, id_sezone, id_domacina, id_gosta;  
            while(fscanf(u, "%d;%d;%d;%d", &id_utak, &id_sezone, &id_domacina, &id_gosta)){
                if(id_sez != id_sezone) continue;
                if(timovi[i].id != id_domacina && timovi[i].id != id_gosta) continue;
                
                broj_ucesca++;
                FILE *g = fopen("golovi.csv", "r");
                int id_gola, id_utakmice, id_tima, id_igraca;
                while(fscanf(g, "%d;%d;%d;%d", &id_gola, &id_utakmice, &id_tima, &id_igraca)){
                    if(id_tima == id_domacina && id_tima == timovi[i].id) broj_golova++; // ako sam dao gol na domacem terenu
                    if(id_tima == id_gosta && id_tima == timovi[i].id) broj_golova++; // ako sam dao gol u gostima

                    if(id_tima == id_domacina && id_tima != timovi[i].id) broj_golova--; // ako sam primio gol od domacina
                    if(id_tima == id_gosta && id_tima != timovi[i].id) broj_golova--; // ako sam primio gol od gosta
                }
                fclose(g);
            }
            fclose(u);
        }
        uspeh[j].sezona = godina;
        uspeh[j++].golovi = broj_golova;
        fclose(s);
    }

    Uspeh max_uspeh = uspeh[0];
    for(int i = 1; i < broj_ucesca; i++)
        if(uspeh[i]->golovi >= max_uspeh->golovi) 
            max_uspeh = uspeh[i];
    
    printf("Najuspesnija sezona tima %s: Godina: %d, postignuti golovi: %d\n", timovi[posao]->naziv, max_uspeh->godina, max_uspeh->golovi);
    free(timovi);
    return 0;
}