from pyspark import SparkConf, SparkContext
import csv
from datetime import date, datetime

conf = SparkContext().setMaster("local").setAppName("Utakmice")
sc = SparkConf(conf = conf)

def getRDDfromCSV(filename):
    return sc.text(filename).filter(lambda x: csv.reader(x))

utakmice = getRDDfromCSV("../Ulaz/utakmice.csv").map(lambda x: ((x[0], x[1]), (x[2], x[3])))

golovi = getRDDfromCSV("../Ulaz/golovi.csv").map(lambda x: ((x[0], x[2]), (x[1], x[3])))

sezona = getRDDfromCSV("../Ulaz/sezona.csv").map(lambda x: (x[0], x[1]))

timovi = getRDDfromCSV("../Ulaz/timovi.csv").map(lambda x: (x[0], x[1]))

golovi_po_utakmici = utakmice.join(golovi).filter(lambda x: x[0][0] == x[1][0]) \
    .map(lambda x: ((x[0][0], x[0][1]), (x[1][0], x[1][1])))
