#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<math.h>

#define MAX_LINE 1000
#define MAX_TIM 1000





typedef struct
{
    int idTima;
    char nazivTima[100];
}Tim;

typedef struct 
{
    int idSez;
    int godina;
}Sezona;


typedef struct 
{
    int id;
    int idTim;
    int idIgrac;
    int god1;
    int god2;
}Ugovor;

typedef struct 
{
    int id;
    int idSez;
    int idDomacin;
    int idGost;
}Utakmica;

typedef struct
{
    int id;
    int idUtakmice;
    int idTim;
    int idIgrac;
}Golovi;





int main(int argc, char **argv)
{
    if(argc<2)
    {
        fprintf(stderr,"prosledjivanje kroz argv\n");
        return 1;
    }

    char line[MAX_LINE];

    Tim timovi[MAX_TIM]={0};
    int brTim=0;

    FILE *fTim=fopen("timovi.csv","r");
    if(!fTim)
    {
        perror("grska kod ucitavanja timovi.csv");
        return 1;
    }

    while(fgets(line,sizeof(line),fTim))
    {
        int idT;
        char naziv[100];
        if(sscanf(line,"%d;%99[^\n]",&idT,naziv)==2)
        {
            timovi[brTim].idTima=idT;
            strcpy(timovi[brTim].nazivTima,naziv);
        }
        brTim++;
    }

    fclose(fTim);


    Sezona sezone[MAX_TIM]={0};
    int brSez=0;
    FILE *fSez=fopen("sezona.csv","r");
    if(!fSez)
    {
        perror("grska kod ucitavanja sezona.csv");
        return 1;
    }
    while(fgets(line,sizeof(line),fSez))
    {
        int idS;
        int godina;
        if(sscanf(line,"%d;%d",&idS,&godina)==2)
        {
            sezone[brSez].idSez=idS;
            sezone[brSez].godina=godina;
        }
        brSez++;
    }
    fclose(fSez);

    Ugovor ugovori[MAX_TIM]={0};
    int brUgo=0;

    FILE *fUgovori=fopen("ugovori.csv","r");
    if(!fUgovori)
    {
        perror("grska kod ucitavanja ugovori.csv");
        return 1;
    }
    while(fgets(line,sizeof(line),fUgovori))
    {
        int id,idTim,idIgrac;
        char datum1[32],datum2[32];
        int dan,mesec;
        if(sscanf(line,"%d;%d;%d;%31[^;],%31[^\n]",&id,&idTim,&idIgrac,datum1,datum2)==5)
        {
            ugovori[brUgo].id=id;
            ugovori[brUgo].idTim;
            ugovori[brUgo].idIgrac=idIgrac;
            sscanf(datum1,"%d.%d.%d",&dan,&mesec,&ugovori[brUgo].god1);
            sscanf(datum2,"%d.%d.%d",&dan,&mesec,&ugovori[brUgo].god2);
        }
        brUgo++;
    }
    fclose(fUgovori);


    Utakmica utakmice[MAX_TIM]={0};
    int brUtak=0;

    FILE *fUtakmice=fopen("utakmice.csv","r");
    if(!fUtakmice)
    {
        perror("grska kod ucitavanja utakmice.csv");
        return 1;
    }
    while(fgets(line,sizeof(line),fUtakmice))
    {
        int id,idSez,idDomacin,idGost;
        if(sscanf(line,"%d;%d;%d;%d",&id,&idSez,&idDomacin,&idGost==4))
        {
            utakmice[brUtak].id=id;
            utakmice[brUtak].idSez=idSez;
            utakmice[brUtak].idDomacin=idDomacin;
            utakmice[brUtak].idGost=idGost;
        }
        brUtak++;
    }
    fclose(fUtakmice);

    Golovi golovi[MAX_TIM]={0};
    int brGolovi=0;
    FILE *fGolovi=fopen("golovi.csv","r");
    if(!fGolovi)
    {
        perror("grska kod ucitavanja golovi.csv");
        return 1;
    }
    while(fgets(line,sizeof(line),fGolovi))
    {
        int id,idUtakmice,idTim,idIgrac;
        if(sscanf(line,"%d;%d;%d;%d",&id,&idUtakmice,&idTim,&idIgrac)==4)
        {
            golovi[brGolovi].id=id;
            golovi[brGolovi].idUtakmice=idUtakmice;
            golovi[brGolovi].idTim=idTim;
            golovi[brGolovi].idIgrac=idIgrac;
        }
        brGolovi++;
    }
    fclose(fGolovi);

    int idTima=atoi(argv[1]);

    int matricaDaoPrimioPoSezonamaKodKuce[brSez][2]={0};
    int matricaDaoPrimioPoSezonamaUGostima[brSez][2]={0};

    for(int i=0;i<brSez;i++)
    {
        for(int j=0;j<brUtak;j++)
        {
            if(sezone[i].id==utakmice[j].idSez && idTima==utakmice[j].idDomacin)
            {
                for(int k=0;k<brGolovi;k++)
                {
                    if(idTima==golovi[k].idTim)
                    {
                        matricaDaoPrimioPoSezonamaKodKuce[i][0]++;
                    }
                    else if(utakmice[j].idGost==golovi[k].idT)
                    {
                        matricaDaoPrimioPoSezonamaKodKuce[i][1]++;
                    }
                }
            }
            else if(sezone[i].id==utakmice[j].idSez && idTima==utakmice[j].idGost)
            {
                for(int k=0;k<brGolovi;k++)
                {
                    if(idTima==golovi[k].idTim)
                    {
                        matricaDaoPrimioPoSezonamaUGostima[i][0]++;
                    }
                    else if(utakmice[j].idDomacin==golovi[k].idT)
                    {
                        matricaDaoPrimioPoSezonamaUGostima[i][1]++;
                    }
                }
            }
        }
    }

    int razlikeKodKuce[brSez];
    int razlikeUGostima[brSez];
    for(int i=0;i<brSez;i++)
    {
        razlikeKodKuce[i]=matricaDaoPrimioPoSezonamaKodKuce[brSez][0]-matricaDaoPrimioPoSezonamaKodKuce[brSez][1];
        razlikeUGostima[i]=matricaDaoPrimioPoSezonamaUGostima[brSez][0]-matricaDaoPrimioPoSezonamaUGostima[brSez][1];
    }
    
    int maxKodKuce=-1;
    int maxUGostima=-1;
    int imaxKuca;
    int imaxGosti;
    for(int i=0;i<brSez;i++)
    {
        if(razlikeKodKuce[i]>maxKodKuce)
        {
            maxKodKuce=razlikeKodKuce[i];
            imaxKuca=i;
        }
        if(razlikeUGostima[i]>maxUGostima)
        {
            maxUGostima=razlikeUGostima[i];
            imaxGosti=i;
        }
    }
    
    printf("%d %d %d",itTima,imaxKuca,imaxGosti);

    return 0;
}
