from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local").setAppName("Utakmice")
sc = SparkContext(conf = conf)

utakmice=sc.textFile("utakmice.csv").map(lambda x:x.split(";")).map(lambda x:(int(x[0]),(int(x[1]),int(x[2]),int(x[3]))))


golovi=sc.textFile("golovi.csv").map(lambda x:x.split(";")).map(lambda x: (int(x[1]),int(x[2])))

sezone=sc.textFile("sezona.csv").map(lambda x:x.split(";")).map(lambda x: (int (x[0]),int(x[1] )))

timovi=sc.textFile("timovi.csv").map(lambda x:x.split(";")).map(lambda x: (int(x[0]),x[1]))
print(golovi.collect())

spojeni=golovi.join(utakmice)


golovi_tip=spojeni.map(lambda x:(
    (x[1][0],x[1][1][0]),
    (1,0) if x[1][0]==x[1][1][1] else (0,1)
))

zbir=golovi_tip.reduceByKey(lambda a, b:(a[0]+b[0],a[1]+b[1]))

diff_po_sezoni=zbir.map(lambda x:(x[0],x[1][1]-x[1][0]))

po_timu=diff_po_sezoni.map(lambda x: (x[0][0],(x[0][1],x[1])))

najbolje=po_timu.reduceByKey(lambda a,b: a if a[1]> b[1] else b)


za_join_sezona=najbolje.map(lambda x: (x[1][0],(x[0],x[1][1])))
sa_godinama=za_join_sezona.join(sezone)

tim_godina_diff=sa_godinama.map(lambda x: (x[1][0][0],(x[1][0],x[1][0][1])))

konacno=tim_godina_diff.join(timovi)
rez=konacno.map(lambda x: (x[1][1],x[1][0][0],x[1][0][1]))
print("Naj sezona po (golovi_gost-golovi domacin) za svaki tim")
for r in rez.collect():
    print(r)
sc.stop()