from pyspark import SparkConf, SparkContext
import csv


conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)


#Исписати за сваки тим његову најуспешнију сезону у односу на гол разлику у гостима и код куће.


def readFromCSV(path):
    x = context.textFile(path).mapPartitions(lambda x : csv.reader(x,delimiter=','))

sezona = readFromCSV('sezona.csv') 
utakmice = readFromCSV('utakmice.csv')
golovi = readFromCSV('golovi.csv')
timovi = readFromCSV('timovi.csv')

utakmice = utakmice.map(lambda x : x = (x[0],(x[1],x[2],x[3]))) #(id_utakmice, (id_sezone, id_domacina, id_gosta))

golovi = golovi.map(lambda x : x = (x[1],(x[0],x[2],x[3]))) #(id_utakmice, (id_tima, id_igraca))

golovi_gost = utakmice.join(golovi).filter(lambda x: x[1][2] == x[2][0]).map(lambda x: x = (x[1][0],(x[2][0],1))) #(id_sezone, (id_gosta, 1))

golovi_domacin = utakmice.join(golovi).filter(lambda x: x[1][1] == x[2][0]).map(lambda x: x = (x[1][0],(x[2][0],1))) #(id_sezone, (id_domacina, 1))

golovi_gost = golovi_gost.reduceByKey(lambda x,y : x[1][1] += y[1][1]).map(lambda x: x = (x[1][0],(x[0],x[1][1]))) #(id_sezone, (id_domacina, x))

golovi_domacin = golovi_domacin.reduceByKey(lambda x,y : x[1][1] += y[1][1]).map(lambda x: x = (x[1][0],(x[0],x[1][1]))) #(id_sezone, (id_gosta, x))

razlika = golovi_gost.join(golovi_domacin).filter(lambda x: x[1][0] == x[2][0]).map(lambda x: x = (x[1][0],(x[0],x[1][1]-x[2][1]))) #(id_tima, (id_sezone, razlika))

razlika = razlika.reduceByKey(lambda x, y: x[1][1] > y[1][1] ? x : y).map(lambda x: x = (x[0],(x[1][0]))) #(id_tima, (id_sezone))

timovi = timovi.map(lambda x: x = (x[0],(x[1]))) #(id_tima,(naziv))

sezona = sezona.map(lambda x: x = (x[0],(x[1]))) #(id_sezone,(godina))

razlika = razlika.join(timovi).map(lambda x: x = (x[1][0],(x[2][0]))) #(id_sezone, (naziv_tima))

razlika = razlika.join(sezona).map(lambda x: x = (x[2][1],(x[1][0]))) #(godina, (naziv_tima))

razlika = razlika.map(lambda x: x = (x[1][0],x[0])) #(naziv_tima,godina)

razlika.saveTextFile('najbolje_sezone.csv')






