from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

sezoneRaw  = sc.textFile("./Ulaz/sezona.csv").split(",")
sezone = sezone_Raw.map(lambda x : (x[0], x[1]))
# (idSezone, godina)


utakmiceRaw = sc.textFile("./Ulaz/utakmice.csv").split(",")
utakmice = utakmiceRaw.map(lambda x: (x[0], x[1], x[2], x[3]))
#(id, idSezone, id_domacina, id_gosta )

timRaw = sc.textFile("./Ulaz/timovi.csv").split(",")
tim = timRaw.map(lambda x: (x[0], x[1]))
#(id, naziv)

goloviRaw = sc.textFile("./Ulaz/golovi.csv").split(",")
golovi = goloviRaw.map(lambda x : (x[0], x[1], x[2], x[3])).partitionBy(4)
#(id, id_utakmice, id_tima, id_igraca)


utakmice_idSez = utakmice.map(lambda x : (x[1], (x[0], x[2], x[3])))
#(idSezone, (idUtakmice, id_domacina, id_gosta))


sezone_utakmice = sezone.join(utakmice_idSez)
#(idSezone, (godina, (id_utakmice, id_domacina, id_gosta)))


brojGolovaJedan = golovi.map(lambda x : ((x[1],x[2]), 1))
#( (id_utakmice,id_tima), 1)

brojGolovaUtakmicaTim = brojGolovaJedan.reduceByKey(lambda x, y : x[1] + y[1])
# ((id_utakmice, id_tima), brGolova)

domacin = utakmice.map(lambda x: ((x[0], x[2]), x[1]) )
#((id_utakmice, id_domacina), id_sezone)

gost = utakmice.map(lambda x: ((x[0], x[3]), x[1]) )
#((id_utakmice, id_gosta), id_sezone)

#((id_utakmice, id_tima), (brGolova, idSezone))
brojGolovaDomacin = brojGolovaUtakmicaTim.join(domacin).map(lambda x: ((x[0][0], x[0][1],x[1][1]), x[1][0]))
#((id_utakmice, id_tima, id_sezone), brGolova)

#((id_utakmice, id_tima), (brGolova, idSezone))
brojGolovaGost = brojGolovaUtakmicaTim.join(gost).map(lambda x: ((x[0][0], x[0][1],x[1][1]), x[1][0]))
#((id_utakmice, id_tima, id_sezone), brGolova)

brGolova = brojGolovaDomacin.join(brojGolovaGost)
#((id_utakmice, id_tima, id_sezone), (brGolovaDom, brGolovaGost))

brGolovaRazlika = brGolova.map(lambda x: ((x[0][0], x[0][1],x[0]2), x[1][0] - x[1][1] ))
#((id_utakmice, id_tima, id_sezone), brGolova)

brGolovaPoSezoni = brGolovaRazlika.map(lambda x: ((x[0][1], x[0][2]), x[1]))
#((id_tima, id_sezone), brojGolova)

timSezonaGolovi = brGolovaPoSezoni.reduceByKey(lambda x, y : x[1] + y[1]).map(lambda x: (x[0][0],(x[0][1], x[1])))

#(id_tima,( idSezona, brojGolova))
timSezona = timSezonaGolovi.reduceByKey(lambda x, y : x[1][1] > y[1][1]).map(lambda x : (x[0],[x[0][0]]))
#nasla max, izdvojila tim, sezonu

timIme = timSezona.join(tim).map(lambda x: (x[1][0], x[1][1]))
#idSezone, nazivTima

sezonaGodina = timIme.join(sezona).map(lambda x : (x[1][0], x[1][1]))
#(nazivTima, godina)


for tim in sezonaGodina :
    print( f"{tim[0]},{tim[1]} \n")

sezonaGodina.saveToTextFile("najuspesnijeSezone.txt")

#(id_tima, idSezone) -> za svaki tim najuspesnija sezona

sc.stop()