from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("My App")
context = SparkContext(conf = conf)

def readFromCSV(path):
    rddCSV = context.textFile(path).mapPartitions(lambda x: csv.reader(x, delimiter=','))
    return rddCSV
    
golovi = readFromCSV('./golovi.csv')
utakmice = readFromCSV('./utakmice.csv')
timovi = readFromCSV('./timovi.csv')
sezona = readFromCSV('./sezona.csv')

golovi = golovi.map(lambda x : (x[1],(x[0],x[2], x[3])))
#idutakmice,(idgola, idtima, idigraca)


utakmice = utakmice.map(lambda x : (x[0], (x[1], x[2], x[3])))
#idutakmice, (idsezone, iddomacina, idgosta)

goloviDomaci = utakmice.join(golovi).filter(lambda x : (x[1][0][1] == x[1][1][1]))
#idutakmice,((idsezone, iddomacina, idgosta), (idgola, idtima, idigraca))

goloviDomaci = goloviDomaci.map(lambda x : ((x[1][0][1],x[1][0][0]), 1))
#(iddomacina, idsezone),1

brojDomaci =  goloviDomaci.reduceByKey(lambda x, y: x + y)
#(iddomacina, idsezone),brojGolovaTimauSezoni



goloviGosti = utakmice.join(golovi).filter(lambda x : (x[1][0][2] == x[1][1][1]))
#idutakmice,((idsezone, iddomacina, idgosta), (idgola, idtima, idigraca))

goloviGosti = goloviGosti.map(lambda x : ((x[1][0][2],x[1][0][0]), 1))
#(idgosta, idsezone), 1

brojGosti = goloviGosti.reduceByKey(lambda x, y : x + y)
#(idgosta, idsezone), brojGolovaTimauSezoni


#fullouterjoin
krajnja = goloviDomaci.fullOuterJoin(goloviGosti)
#(idtima, idsezone),(golovidomaci, golovigosti)
#(idtima, idsezone),(null ako tim nema golove kao domaci te sezone, null ako tim nema golove kao gost te sezone)

krajnja = krajnja.map(lambda x : ((x[0][0], x[0][1]), (0 if (x[1][0]=='NULL' or x[1][0]=='null' or x[1][0]==None or x[1][0]=='') else x[1][0], 0 if (x[1][1]=='NULL' or x[1][1]=='null' or x[1][1]==None or x[1][1]=='') else x[1][1])))
#pretvara golove goste i golove domacine u 0 ako su null da ne bismo izgubili tu sezonu i da bismo mogli da nadjemo razliku

krajnja = krajnja.map(lambda x : ((x[0][0],x[0][1]), (x[1][1]-x[1][0])))
#(idtima, idsezone),razlika(gosti-domaci)


#####
resenje = krajnja.reduceByKey(lambda x, y: x if x>y else y)
#(idtima, idsezonesanajvecom razlikom), najveca razlika

resenje = resenje.map(lambda x: (x[0][0], (x[0][1], x[1])))
#id tima, (idsezone, razlika)

resenjeImena = resenje.join(timovi)
#idtima,((idsezone, razlika), naziv)
resenjeImena = resenjeImena.map(lambda x : (x[1][0][0],(x[0],x[1][0][1],x[1][1])))
#idsezone,(idtima, razlika, nazivtima)

resenjeImena = resenjeImena.join(sezona)
#idsezone,((idtima, razlika, nazivtima), godina)

resenjeImena = resenjeImena.map(lambda x : (x[1][0][2], x[1][1]))
#nazivtima, godina

#resenjeImena = resenjeImena.map(lambda x : f"{x[0]}, {x[1]}")

#resenjeImena.toTextFile('najboljaSezona.csv')





