from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("My App")
context = SparkContext(conf = conf)


def readFromCSV(path):
    readRDD = context.textFile(path).mapPartitions(lambda x : csv.reader(x, delemetar=';'))
    return readRDD


golovi = readFromCSV('./golovi.csv')
utakmice = readFromCSV('./utakmice.csv')

#idsezone,idtima,brojgolovaGost
#idsezone,idtima,brojgolovaDomacin


golTim = golovi.map(lambda x : ((x[1],x[2]),1)) #(idutakmice,idtima),1
gol_Gost = golovi.map(lambda x : ((x[1],x[2]),-1))

#domacin-razlika
utakmicaDom = utakmice.map(lambda x : ((x[0],x[2]), x[1] )) #((idu,iddom),idsezone)
utakmicaGost = utakmice.map(lambda x : ((x[0],x[3]), x[1] )) #((idu,idgost),idsezone)

goloviDom = utakmicaDom.join(golTim) #((idu,iddom),(1,idsezone))
goloviDom = goloviDom.map(lambda x : ((x[1][1],x[0][1]), 1 )) #(ids,idtima),1
goloviDomSum = goloviDom.reduceByKey(lambda x,y : x+y) #dati

utakmicaDom = utakmice.map(lambda x : ((x[0],x[3]), x[1], x[2] )) #gost
golovi_Dom = utakmice.join(gol_Gost) #((idu,idgost),(-1,(idsezone,idDom))
golovi_Dom = golovi_Dom.map(lambda x : ( (x[1][1][0],x[0][0],x[1][1][1]), -1 ))
golovi_DomSum = golovi_Dom.reduceByKey(lambda x,y: x+y).map(lambda x : ((x[0][0],x[0][2]),x[1])).reduceByKey(lambda x,y : x+y)  #(ids,itdom), -ukupno /primljeni

razlikaDomacin = golovi_DomSum.join(goloviDomSum).reduceByKey(lambda x,y : x+y) #(ids,iddom),razlika


# print(najboljaDomacaSezona.take(5))

#gost-razlika
goloviGost = utakmicaGost.join(golTim) #((idu,idgost),(1,idsezone))
goloviGost = goloviGost.map(lambda x : ((x[1][1],x[0][1]), 1 )) #(ids,idtima),1
goloviGostSum = goloviDom.reduceByKey(lambda x,y : x+y) #dati kao gost

utakmicaGost = utakmice.map(lambda x : ((x[0],x[2]), x[1], x[3] )) #domacin
golovi_Gost = utakmice.join(gol_Gost) #((idu,iddom),(-1,(idsezone,idGost))
golovi_Gost = golovi_Gost.map(lambda x : ( (x[1][1][0],x[0][0],x[1][1][1]), -1 ))
golovi_GostSum = golovi_Gost.reduceByKey(lambda x,y: x+y).map(lambda x : ((x[0][0],x[0][2]),x[1])) #(ids,itgost), -ukupno /primljeni

razlikaGost = golovi_GostSum.join(goloviGostSum).reduceByKey(lambda x,y : x+y) #(ids,idgost),razlika


najboljeSezone = razlikaDomacin.join(razlikaGost) #((ids,idgost),(razlikad,razlikag))
najboljeSezone = najboljeSezone.map(lambda x : ( (x[0][0],x[0][1]) , max(x[1][0],x[1][1])))
najboljeSezone = najboljeSezone.reduceByKey(lambda x,y : x if x[1] > y[1] else y)

print(najboljeSezone.take(10))



