#!/bin/bash

rm [0-9].csv [0-9].out slurm* obrada 2> /dev/null

BROJ_LINIJA=$(wc -l < "timovi.csv")
LINIJA_PO_FAJLU=$(($BROJ_LINIJA/4))

split -l $LINIJA_PO_FAJLU "timovi.csv" ulaz_

i=0
for fajl in ulaz_*
do
    mv "$fajl" "$i.csv"
    i=$((i+1))
done

gcc -std=c99 -o obrada obrada.c
chmod +x obrada

BROJ_POSLOVA=$i
ARRAY_RANGE=$("0-$(($BROJ_POSLOVA-1))")

JOB_ID=$(sbatch --array="$ARRAY_RANGE" posao.slurm | awk '{print $4}')
echo "Poslat array sa JOB_ID: $JOB_ID"

while squeue -j $JOB_ID -h | grep -q .
do
    sleep 2
done

echo "Svi poslovi su izvrseni."

>najuspesnijeSezone.txt

cat *.out > najuspesnijeSezone.txt

echo "Rezultat je u fajlu najuspesnijeSezone.txt"