from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

def readFromCSV(path):
    rddCSV = sc.textFile(path).mapPartitions(lambda x: csv.reader(x, delimiter=','))
    return rddCSV

#Исписати за сваки тим његову најуспешнију сезону у односу на гол разлику у гостима и код куће.

timovi = readFromCSV("timovi.csv")
sezone = readFromCSV("sezona.csv")
utakmice = readFromCSV("utakmice.csv")
golovi = readFromCSV("golovi.csv")

timovi = timovi.map(lambda x: (x[0], x[1]))
sezone = sezone.map(lambda x: (x[0], x[1]))
utakmice = utakmice.map(lambda x: (x[0], (x[1], x[2], x[3])))
golovi = golovi.map(lambda x: (x[1], (x[0], x[2])))

utakmiceGolovi = utakmice.join(golovi)
utakmiceGoloviDomaci = utakmiceGolovi.filter(lambda x: x[1][1][2]==x[1][0][2])
utakmiceGoloviDomaci = utakmiceGolovi.filter(lambda x: x[1][1][2]==x[1][0][3])