from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

# Исписати за сваки тим 
# његову најуспешнију сезону у односу на гол разлику ukupno.

# koliko su dali - koliko su primili

def readFromCsv(path):
    return sc.textFile(path).mapPartitions(lambda x: csv.reader(x, delimiter=";"))

timovi = readFromCsv("Ulaz/timovi.csv")
sezona = readFromCsv("Ulaz/sezona.csv")

utakmice = readFromCsv("Ulaz/utakmice.csv")
golovi = readFromCsv("Ulaz/golovi.csv")

utakmiceDomacin = utakmice.map(lambda x: (x[0], x[1], x[2]))
utakmiceGost = utakmice.map(lambda x: (x[0], x[1], x[3]))

# id, id_sezone, id_tima
utakmice1 = utakmiceDomacin.union(utakmiceGost)

# print("--------")
# print(utakmice1.collect())

utakmice1 = utakmice1.map(lambda x: ((x[0], x[2]), x[1]))

# ovo ako join sa golovi
# ako je left join
# id_utakmice, id_sezone, id_tima, broj golova
# 1, 1, 1, 2
# 1, 1, 2, None 
# map x[3] or 0

# id_utakmice, id_tima -> id_sezone, broj golova na utakmici (tog tima)
goloviNaUtakmicama = utakmice1.leftOuterJoin(golovi)\
    .map(lambda x: ((x[0][0], x[0][1]), (x[1][0], x[1][1] or 0)))
# print("--------")
# print(goloviNaUtakmicama.collect())

goloviNaUtakmicama = goloviNaUtakmicama \
    .map(lambda x: ( (x[0][0]), (x[0][1], x[1][1]) ))

# print("--------")
# print(goloviNaUtakmicama.collect())


# id_utakmice, (tim1, golovi1), (tim2, golovi2)
finalGolovi = goloviNaUtakmicama.join(goloviNaUtakmicama) \
    .filter(lambda x: (x[1][0][0] != x[1][1][0]))

print("--------")
print(finalGolovi.collect())


# ('4', (('1', 0), ('2', 0))), 
# ('4', (('2', 0), ('1', 0))), 
# ('3', (('1', 0), ('4', 0))), 
# ('3', (('4', 0), ('1', 0))), 
# ('2', (('1', 2), ('3', 1))), 
# ('2', (('3', 1), ('1', 2))), 
# ('1', (('1', 2), ('2', 1))), 
# ('1', (('2', 1), ('1', 2))), 
# ('8', (('3', 0), ('4', 0))), 
# ('8', (('4', 0), ('3', 0))), 
# ('9', (('3', 0), ('4', 0))), 
# ('9', (('4', 0), ('3', 0))), 
# ('5', (('2', 0), ('4', 0))), 
# ('5', (('4', 0), ('2', 0))), 
# ('6', (('3', 0), ('2', 0))), 
# ('6', (('2', 0), ('3', 0))), 
# ('7', (('2', 0), ('4', 0))), 
# ('7', (('4', 0), ('2', 0)))
