from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("resenje")
context = SparkContext(conf = conf)

def readFromCSV(path):
    RDD = context.textFile(path).mapPartitions(lambda x : csv.reader(x,delimiter=';'))
    return RDD


sezone = readFromCSV('./sezona.csv')
utakmice1 = readFromCSV('./utakmice.csv')
utakmice2 = readFromCSV('./utakmice.csv')
golovi = readFromCSV('./golovi.csv')
timovi= readFromCSV('./timovi.csv')

# utakmice(id_utakmice,id_sezone,id_domacina,id_gosta)
# golovi(Id_gola,id_utakmice,id_tima,id_igraca)
# sezona (id_sezone,godina)

golovi=golovi.map(lambda x : (x[2],(x[0],x[1],x[3])))

utakmiceMapD=utakmice1.map(lambda x : (x[2],(x[0],x[1],x[3])))
utakmiceMapG=utakmice2.map(lambda x : (x[3],(x[0],x[1],x[2])))

utakmiceD= utakmiceMapD.join(golovi) # (idtima((id_utakmice,id_sezone,id_gosta),(Id_gola,id_utakmice,id_igraca)))
brGolovaDomaci = utakmiceD.map(lambda x: ((x[0],x[1][0][1]),1)).reduceByKey(lambda x,y : x+y) #((idTima,idSezone),brGolovaD)

utakmiceG= utakmiceMapG.join(golovi) # (idtima((id_utakmice,id_sezone,Id_domaci),(Id_gola,id_utakmice,id_igraca)))
brGolovaGosti = utakmiceG.map(lambda x: ((x[0],x[1][0][1]),1)).reduceByKey(lambda x,y : x+y) #((idTima,idSezone),brGolovaG)

ukupnoDatihPoSezoni = brGolovaDomaci.join(brGolovaGosti).map(lambda x : (x[0],x[1][1]+x[1][0])) #((idTima,idSezone),BrDatihPoSezoni)
print(ukupnoDatihPoSezoni)
brPrimljenihDomaci=utakmiceD.map(lambda x :((x[1][0][2],x[1][0][1]),1)).reduceByKey(lambda x,y:x+y) #((idTima,idSezone),brPrimljenihGolovaD)
brPrimljenihGost = utakmiceG.map(lambda x :((x[1][0][2],x[1][0][1]),1)).reduceByKey(lambda x,y:x+y) #((idTima,idSezone),brPrimljenihGolovaG)


ukupnoPrimljenihPoSezoni = brPrimljenihDomaci.join(brPrimljenihGost).map(lambda x : (x[0],x[1][1]+x[1][0])) #((idTima,idSezone),BrPrimljenihPoSezoni)

razlika = ukupnoDatihPoSezoni.join(ukupnoPrimljenihPoSezoni).map(lambda x : (x[0],x[1][0]-x[1][1])).map(lambda x : (x[0][0],(x[0][1],x[1]))) #(idTima,(idSezone,razlika))

najboljeSezoneTimova = razlika.reduceByKey(lambda x,y : x if x[1][1]>y[1][1] else y) #(idTima,(idSezone,razlika))

resenje = najboljeSezoneTimova.map(lambda x : (x[1][0],x[0])).join(sezone).map(lambda x : (x[1][0],x[1][1])).join(timovi).map(lambda x : (x[1][1],x[1][0])) #(nazivTima,sezona)


resenje.saveAsTextFile('./najboljeSezoneTimova.csv')