from pyspark import SparkConf, SparkContext
import csv

conf = SparkConf().setMaster("local").setAppName("igraci")
sc = SparkContext(conf = conf)

def readFromCSV(path):
    rddCSV = sc.textFile(path).mapPartitions(lambda x : csv.reader(x,delimiter=';'))
    return rddCSV

utakmice = readFromCSV('utakmice.csv')
golovi = readFromCSV('golovi.csv')
timovi = readFromCSV('timovi.csv')
sezona = readFromCSV('sezona.csv')

#(id_utakmice,id_sezone,id_domacina,id_gosta,id_tima)
golovi_utakmice_po_sezoni = utakmice.map(lambda x: (x[0],x[1:])).join(golovi.map(lambda x : (x[1],x[2])))\
.map(lambda x: (x[0],x[1][0][0],x[1][0][1],x[1][0][2],x[1][1]))

#DALI KAO DOMACINI

#((id_utakmice,id_sezone,id_tima),postignutiGolovi)
golovi_domacini_po_utakmici_i_sezoni = golovi_utakmice_po_sezoni.filter(lambda x : (x[2] == x[4])).map(lambda x: ((x[0],x[1],x[4]),1)).reduceByKey(lambda x,y : x+y)

#((id_sezone,id_tima),postignutiGolovi)
golovi_domacini_po_sezoni = golovi_domacini_po_utakmici_i_sezoni.map(lambda x : ((x[0][1],x[0][2]),x[1])).reduceByKey(lambda x,y : x+y)

#DALI KAO GOSTI

#((id_utakmice,id_sezone,id_tima),postignutiGolovi)
golovi_gosti_po_utakmici_i_sezoni = golovi_utakmice_po_sezoni.filter(lambda x : (x[3] == x[4])).map(lambda x: ((x[0],x[1],x[4]),1)).reduceByKey(lambda x,y : x+y)

#((id_sezone,id_tima),postignutiGolovi)
golovi_gosti_po_sezoni = golovi_gosti_po_utakmici_i_sezoni.map(lambda x : ((x[0][1],x[0][2]),x[1])).reduceByKey(lambda x,y : x+y)

#PRIMILI KAO DOMACINI

#((id_sezone,id_tima),postignutiGolovi)
primili_kao_domacini_po_sezoni = golovi_gosti_po_utakmici_i_sezoni.map(lambda x : (x[0][0],(x[0][1],x[1])))\
.join(utakmice.map(lambda x:(x[0],x[1:]))).map(lambda x :((x[1][0][0],x[1][1][1]),x[1][0][1])).reduceByKey(lambda x,y : x+y)

#PRIMILI KAO GOSTI

#((id_sezone,id_tima),postignutiGolovi)
primili_kao_gosti_po_sezoni = golovi_domacini_po_utakmici_i_sezoni.map(lambda x : (x[0][0],(x[0][1],x[1])))\
.join(utakmice.map(lambda x:(x[0],x[1:]))).map(lambda x :((x[1][0][0],x[1][1][2]),x[1][0][1])).reduceByKey(lambda x,y : x+y)

#((id_sezone,id_tima),postignuti)
zbir_datih_kao_domaci_ili_gosti=golovi_domacini_po_sezoni.fullOuterJoin(golovi_gosti_po_sezoni)\
.reduceByKey(lambda x,y : x[0]+y[0]+x[1]+y[1])

#((id_sezone,id_tima),primljeni)
zbir_primljenih_kao_domaci_ili_gosti=primili_kao_domacini_po_sezoni.fullOuterJoin(primili_kao_gosti_po_sezoni)\
.reduceByKey(lambda x,y : x[0]+y[0]+x[1]+y[1])

#((id_sezone,id_tima),razlika)
ukupna_razlika = zbir_datih_kao_domaci_ili_gosti.fullOuterJoin(zbir_primljenih_kao_domaci_ili_gosti)\
.reduceByKey(lambda x,y: x[0]-x[1]+y[0]-y[1])

#(id_tima,((id_sezone,razlika),naziv)) -> (id_sezone,(naziv,razlika))
sredjenaRazlika = ukupna_razlika.map(lambda x: (x[0][1],(x[0][0],x[1]))).join(timovi)\
.map(lambda x : (x[1][0][0],(x[1][1],x[1][0][1])))

#(id_sezone,((naziv,razlika),godina))
sredjenaPoSezoni = sredjenaRazlika.join(sezona).map(lambda x :(x[1][1],x[1][0][0],x[1][0][1]))

sredjenaPoSezoni.saveAsTextFile('razlike.csv')

print(zbir_datih_kao_domaci_ili_gosti.take(10))
print(zbir_primljenih_kao_domaci_ili_gosti.take(10))



