from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

golovi_raw = sc.textFile("golovi.csv)
utakmice_raw = sc.textFile("utakmice.csv")
sezone_raw = sc.textFile("sezone.csv")
timovi_raw = sc.textFile("timovi.csv")

timovi_imena = timovi_raw.map(lambda x: x.split(",")
sezone_godine = sezone_raw.map(lambda x: (x.split(",")[0],x.split(",")[1]))

#idtima,idsezone,(goldomacin,golgost)

def utakmice(x):
	x.split(",")
	return (x[0],(x[1],x[2],x[3]))

utakmice_map = utakmice_raw.map(utakmice)
#id , (id_sez,id_dom,id_gos)

golovi_map = golovi_raw.map(lambda x: (x.split(",")[1],x.split(",")[2]))
#id_utak,id_tima

utakmice_i_golovi = golovi_map.join(utakmice_map)

def razlika(x):
	daogol= x[0]
	sezona_id=x[1][0]
	domacin = x[1][1]
	gost = x[1][2]
	if daogol == domacin:
		protivnik = gost
	else:
		protivnik = domacin
		
	return [((daogol,sezona_id),1),((protivnik,sezona_id),-1)]
	
golrazlika = utakmice_i_golovi.flatMap(lambda x: razlika(x[1]))

razlika_po_sezoni = golrazlika.reduceByKey(lambda a,b:a+b)

po_timu = razlika_po_sezoni.map(lambda x: (x[0][0],(x[0][1],x[1])))

najbolje_sezone = po_timu.reduceByKey(lambda a,b: a if a[1]>b[1] else b)


sezone_i_imena=najbolje_sezone.join(timovi_imena)
mapirano=sezone_i_imena.map(lambda x : (x[1][0][0],(x[1][1],x[1][0][1])))

finalni = mapirano.join(sezone_godine)

ispis = finalni.map(lambda x : f"{x[1][0][0],(x[1][1],x[1][0][1]}")

ispis.saveAsTextFile("najbolje_sezone.csv")

sc.stop()
