from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

utakmice = sc.textFile('./utakmice.csv').mapPartitions(lambda x : csv.reader(x, delimiter=';'))
golovi = sc.textFile('./golovi.csv').mapPartitions(lambda x : csv.reader(x, delimiter=';'))
sezona = sc.textFile('./sezona').mapPartitions(lambda x : csv.reader(x, delimiter=';'))
timovi = sc.textFile('./timovi').mapPartitions(lambda x : csv.reader(x, delimiter=';'))

svi_golovi = utakmice.join(golovi.map(lambda x : (x[1], x[2])))/
            .map(lambda x : (x[1][1], (x[0], x[1][0][0], x[1][0][1], x[1][0][3])))

golovi_domacin = svi_golovi.join(svi_golovi.map(lambda x : (x[1][2], 1)))\
                .map(lambda x : (x[0], (x[1][0][1], x[1][1])))\
                .map(lambda x : ((x[0], x[1][0]), x[1][1]))\
                .reduceByKey(lambda x, y: x + y)

golovi_gost = svi_golovi.join(svi_golovi.map(lambda x : (x[1][3], 1)))\
                .map(lambda x : (x[0], (x[1][0][1], x[1][1])))\
                .map(lambda x : ((x[0], x[1][0]), x[1][1]))\
                .reduceByKey(lambda x, y: x + y)

tim_sezona = golovi_domacin.join(golovi_gost).filter(lambda x : x[1][0] - x[1][1])


