#!/bin/bash

set -e

rm -f *.txt *.out *.err

split -l 2 timovi.csv tm

i=0
for fajl in tm*; 
do 
    mv "$fajl" "deo_${i}.csv"
    i=$((i+1)) 
done

gcc utakmice.c -o u
chmod +x u

jid=$(sbatch --parsable job.slurm)

echo "Zapocet job ${jid}"

while squeue -h -j "$jid" | grep -q .;
do
    sleep 2
done

for fajl in izlazi*.txt; 
do
    cat "$fajl" >> konacan.txt
done

echo "Zavrsen job ${jid}"