import csv
from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local")
sc = SparkContext(conf = conf)
sc.setLogLevel("ERROR")

print("----------------------")
print("\n\nZadatak:\n")

def ucitaj(fajl):
	return sc.textFile(fajl).mapPartitions(lambda x: csv.reader(x)).map(lambda x: x[0].split(";"))

def stampajRdd(rdd, naziv):
	print("\n")
	print(naziv if naziv else "Kolekcija" )
	print(rdd.collect())
	print("\n")
	

timovi = ucitaj("timovi.csv")
stampajRdd(timovi, "Timovi")

utakmice = ucitaj("utakmice.csv")
stampajRdd(utakmice, "Utakmice")

golovi = ucitaj("golovi.csv")
stampajRdd(golovi, "Golovi")


#izlaz: id tima, id sezona u gostima - sezona kod kuce
#ukupan broj datih golova u sezoni - ukupan broj datih golova od strane protivnika

#Ukupno datih golova na utakmici od strane tima
#id utakmice, id tima
goloviTimUtakmica = golovi.map(lambda x: ((x[1], x[2]), 1))
#stampajRdd(goloviTimUtakmica, "Id, utakmice, id tima - racuna se kao jedan goal")

#(id utakmice, id tima), broj golova
ukupniBodoviZaTimNaUtakmici = goloviTimUtakmica.reduceByKey(lambda a, b: a + b)
#stampajRdd(ukupniBodoviZaTimNaUtakmici, "ukupniBodoviZaTimNaUtakmici")

#id utakmice, (id tima, broj datih golova)
utakmicaRezTim = ukupniBodoviZaTimNaUtakmici.map(lambda x: (x[0][0],(x[0][1], x[1]) ))
#stampajRdd(utakmicaRezTim,"id utakmice, (id tima, broj datih golova)" )

#utakmica id, sezona id
utakmicePoId = utakmice.map(lambda x: (x[0], x[1]))
#stampajRdd(utakmicePoId, "utakmice: utakmica id, sezona id")

#join utakmice & rezultati utakmice po timu
# id utakmice, (id sezone, (id tim, broj datih golova na utakmici))
utakmiceSaBrojemGolovaPoTimu = utakmicePoId.join(utakmicaRezTim)
#stampajRdd(utakmiceSaBrojemGolovaPoTimu, "join utakmice & rezultati utakmice po timu\n  id utakmice, (id sezone, (id tim, broj datih golova na utakmici))")

timDatiGoloviUSezoni = utakmiceSaBrojemGolovaPoTimu.map(lambda x: ((x[1][0], x[1][1][0]), x[1][1][1])).reduceByKey(lambda a, b: a + b)
#stampajRdd(timDatiGoloviUSezoni, "dati golovi za tim u sezoni: (id sezone, id tima), brojGolova ")

#id utakmice, id tima, broj izgubljenih golova
#broj izgubljenih golova
rezultatiZaPoredjenje = utakmicaRezTim.join(utakmicaRezTim).filter(lambda x: x[1][0][0] != x[1][1][0] )
#stampajRdd(rezultatiZaPoredjenje, "Join")

#(utakmica, tim), (dati, izgubljeni)
timUtakmicaDobijeniIIzgubljeni = rezultatiZaPoredjenje.map(lambda x: (x[0], (x[1][0][0], x[1][0][1], x[1][1][1])))
#stampajRdd(timUtakmicaDobijeniIIzgubljeni, "#(utakmica, (tim, dati, izgubljeni)")

timUtakmicaDobijeniIIzgubljeniSezona = timUtakmicaDobijeniIIzgubljeni.join(utakmicePoId).map(lambda x: (x[1][1], x[1][0])).map(lambda x: ((x[0], x[1][0]), (x[1][1] - x[1][2])))
#stampajRdd(timUtakmicaDobijeniIIzgubljeniSezona, "sezona, tim - razlika")

sezonaTimRez = timUtakmicaDobijeniIIzgubljeniSezona.reduceByKey(lambda a, b: a + b)
#stampajRdd(sezonaTimRez, "Rezultat:")

print("Rez: tim - sezona")
for s in sezonaTimRez.collect():
	print(s[0][1], s[0][0])




	













