#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#define MAX 100

char timovi[MAX][100];
int postojiTim[MAX]={0};
int postojiSezona[MAX]={0};
int utakmicaSezona[MAX]={0};
int utakmicaDomacin[MAX]={0};
int utakmicaGost[MAX]={0};
int golRazlika[MAX][MAX]={0};
int maxGolRazlika[MAX]={0};
int maxSezona[MAX]={0};

void ucitajTimove(){
    
    char line[256];
    FILE *t = fopen("timovi.csv","r");

    int idTima;
    char nazivTima[100];

    while(fgets(line,256,t)){

        sscanf(line,"%d;%[^\n\r]",&idTima,nazivTima);
        strcpy(timovi[idTima],nazivTima);
        postojiTim[idTima]=1;
    }
    fclose(t);
}

void ucitajUtakmice(){

    char line[256];
    FILE *u = fopen("utakmice.csv","r");

    int idUtakmice;
    int idSezone;
    int idDomacina;
    int idGosta;

    while(fgets(line,256,u)){

        sscanf(line,"%d;%d;%d;%d",&idUtakmice,&idSezone,&idDomacina,&idGosta);
        postojiSezona[idSezone]=1;
        utakmicaSezona[idUtakmice]=idSezone;
        utakmicaDomacin[idUtakmice]=idDomacina;
        utakmicaGost[idUtakmice]=idGosta;
    }
    fclose(u);
}

void mapFaza(char* fajl){

    char line[256];
    FILE *m = fopen(fajl,"r");

    int idGola;
    int idUtakmice;
    int idTima;
    int idIgraca;
    int protivnik;
    int sezona;

    while(fgets(line,256,m)){

        sscanf(line,"%d;%d;%d;%d",&idGola,&idUtakmice,&idTima,&idIgraca);
        sezona = utakmicaSezona[idUtakmice];
        golRazlika[idTima][sezona]++;
        if(idTima==utakmicaDomacin[idUtakmice])
        {
            protivnik = utakmicaGost[idUtakmice];
            golRazlika[protivnik][sezona]--;
        }
        if(idTima==utakmicaGost[idUtakmice])
        {
            protivnik = utakmicaDomacin[idUtakmice];
            golRazlika[protivnik][sezona]--;
        }
    }

    for(int i=0;i<MAX;i++)
    {
        for(int j=0;j<MAX;j++)
        {
            if(postojiTim[i] && postojiSezona[j]) 
            {
                printf("%d,%s,%d,%d\n",i,timovi[i],golRazlika[i][j],j);
            }
        }
    }

    fclose(m);
}

void reduceFaza(){

    char line[256];
    FILE *r = fopen("svi.txt","r");
    FILE *out = fopen("najuspesnijeSezone.csv","w");

    int idTima;
    char nazivTima[100];
    int golRazlika;
    int idSezone;

    while(fgets(line,256,r)){

        sscanf(line,"%d,%[^,],%d,%d",&idTima,nazivTima,&golRazlika,&idSezone);
        if(golRazlika>maxGolRazlika[idTima])
        {
            maxGolRazlika[idTima]=golRazlika;
            maxSezona[idTima]=idSezone;
        }
    }
    
    fclose(r);

     for(int i=0;i<MAX;i++)
    {
        if(postojiTim[i]) 
        {
            fprintf(out,"Tim: %s, Gol razlika: %d, Sezona: %d\n",timovi[i],maxGolRazlika[i],maxSezona[i]);
        }
    }

    fclose(out);
}

int main(int argc,char* argv[])
{
    ucitajTimove();
    ucitajUtakmice();

    if(argc>1)
        mapFaza(argv[1]);
    else
        reduceFaza();

    return 0;

}



