from pyspark import SparkConf, SparkContext

conf = SparkConf().setMaster("local").setAppName("My App")
sc = SparkContext(conf = conf)

def toRdd(csv):
    return sc.textFile(csv).map(lambda x: [y.strip() for y in x.split(';')])

sezone = toRdd("Ulaz/sezona.csv").map(lambda x: (x[0], x[1]))
#(id_sezone, godina)
utakmice = toRdd("Ulaz/utakmice.csv").map(lambda x: (x[1], (x[0], x[2], x[3])))
#(id_sezone, (id_utakmice, id_domacina, id_gosta))
golovi = toRdd("Ulaz/golovi.csv").map(lambda x: (x[1], (x[0], x[2], x[3])))
#(id_utakmice, (id_gola, id_tima, id_igraca))

utakmiceUsezonama = sezone.join(utakmice) \
    .map(lambda x: (x[1][1][0], (x[1][1][1], x[1][1][2], x[1][0])))
#(id_utakmice, (id_domacina, id_gosta, godina))

daoGolova = utakmiceUsezonama.join(golovi) \
    .filter(lambda x: (x[1][0][0] == x[1][1][1] or x[1][0][1] == x[1][1][1])) \
    .map(lambda x: ((x[1][1][1], x[1][0][2])), 1)
#filtriram one gde je id_domacina = id_tima ili id_gosta=id_tima i dobijam
#((id_tima, godina), 1)

daoGolova = daoGolova.reduceByKey(lambda x,y: x+y)
#((id_tima, godina), ukupnoDatihGolovauSezoni)

primioGolovaKaoDomacin = utakmiceUsezonama.join(golovi) \
    .filter(lambda x: (x[1][0][0] != x[1][1][1] and x[1][1][1] == x[1][0][1])) \
    .map(lambda x: ((x[1][0][0], x[1][0][2])), -1)
#((id_domacina, godina), -1)

primioGolovaKaoGost = utakmiceUsezonama.join(golovi) \
    .filter(lambda x: (x[1][0][1] != x[1][1][1] and x[1][1][1] == x[1][0][0])) \
    .map(lambda x: ((x[1][0][1], x[1][0][2])), -1)
#((id_gosta, godina), -1)

primioGolova = primioGolovaKaoDomacin.join(primioGolovaKaoGost) \
    .reduceByKey(lambda x,y: x+y)
#((id_tima, godina), ukupnoPrimljenihGolovauSezoni)

ukupnaRazlika = daoGolova.join(primioGolova).reduceByKey(lambda x,y: x+y)
#((id_tima, godina), gol_razlika)

ukupnaRazlika = ukupnaRazlika.map(lambda x: (x[0][0], x[0][1], x[1]))
for x in ukupnaRazlika.collect():
    print(x)
