//g++ -o p main.cpp -lGL -lglut -lGLU

#define GLM_ENABLE_EXPERIMENTAL
#define GLM_MATH_DEFINES
#define _CRT_NO_WARNINGS

#include <GL/freeglut.h>
#include <glm/vec3.hpp>
#include <glm/mat4x4.hpp>
#include <glm/gtx/transform.hpp>
#include <glm/gtx/rotate_vector.hpp>
#include <vector>
#include <stdio.h>
#include <math.h>

using namespace glm;
using namespace std;

#define MOVING_CONST 0.1
#define ROTATION_CONST 3.14f / 180.f
#define LOOK_MOVEMENT_CONST 0.1f

/*--------------------------------------------------*/

char title[] = "Prozor";
int FPS = 60;
vec3 MotorPosition(0.0, 1.0, 0.0);
vec3 LookAt_vector(0.0, 1.0, 1.0);
vec3 LookUp_vector(0.0, 1.0, 1.0);


vector<vec3> coordinateSystem;

const int circle_dots = 50;
const float height = 480;
const float ratio = 16.f / 9.f;
double upDownAngle = 0;
int currentSpeed = 1;
float arrowRotate = 0.f;

vec3 operator* (mat4x4 mat, vec3 vec)
{
	vec4 v(vec.x, vec.y, vec.z, 1.f);
	v = mat * v;
	return vec3(v.x, v.y, v.z);
}

vector<vec3> operator* (mat4x4 mat, vector<vec3> vectors)
{
	for (int i = 0; i < vectors.size(); i++)
		vectors[i] = mat * vectors[i];
	return vectors;
}


void Transform(mat4X4 transform, vector<vec3> &poly){
    for(int i=0;i<poly.size();i++)
    poly[i]=transform*poly[i];
}

void Transform(mat4X4 transform, vector<vector<vec3>> &poly){
    for(int i=0;i<poly.size();i++)
        for(int j=0;j<poly[i].size();j++){
        poly[i][j]=transform*poly[i][j];
    }
}


void DrawPolygon(vector<vector<vec3>> &poly)
    glBegin(GL_POLYGON);
    for(int i=0;i<poly.size();i++)
    glVertex3f(poly[i].x,poly[i].y,poly[i].z);
    glEnd();


void DrawPolygons(vector<vector<vec3>> &polys)
    
    for(int i=0;i<polys.size();i++)
        for(int j=0;j<polys[i].size;j++)
    DrawPolygon(polys[i]);



//o GLUT_BITMAP_TIMES_ROMAN_24
//o GLUT_BITMAP_TIMES_ROMAN_10
//o GLUT_BITMAP_HELVETICA_18

void RenderString(float x, float y, void* font, double r, double g, double b)
{
	glColor3f(r, g, b);
	glRasterPos2f(x, y);

	char s[100];
	sprintf(s, "x = %.2lf\ny = %.2lf\nz = %.2lf", MotorPosition.x, MotorPosition.y, MotorPosition.z);
	glutBitmapString(font, (const unsigned char*)s);
}

/*--------------------------------------------------*/

class Color{

 public:
    float r;
    float g;
    float b;

    Color(float r1,float g1,float b1):
     r(r1),g(g1),b(b1){

     }

};



Color white=Color(1.f,1.f,1.f);
Color black=Color(0.f,0.f,0.f);
Color green=Color(0.f,1.f,0.f);
Color cyan=Color(0.f,1.f,1.f);
Color gray=Color(0.5f,0.5f,0.5f);



void createCoordinates()
{
	coordinateSystem.resize(4);
	coordinateSystem[0] = vec3(0.0, 0.0, 0.0);
	coordinateSystem[1] = vec3(1.0, 0.0, 0.0);
	coordinateSystem[2] = vec3(0.0, 1.0, 0.0);
	coordinateSystem[3] = vec3(0.0, 0.0, 1.0);
}

void drawCoordinates()
{
	glLineWidth(2.0);
	glBegin(GL_LINES);
	// X axis
	glColor3f(1.0f, 0.0f, 0.0f); // Red
	glVertex3d(coordinateSystem[0].x, coordinateSystem[0].y, coordinateSystem[0].z);
	glVertex3d(coordinateSystem[1].x, coordinateSystem[1].y, coordinateSystem[1].z);
	// Y axis
	glColor3f(0.0f, 1.0f, 0.0f); // Green
	glVertex3d(coordinateSystem[0].x, coordinateSystem[0].y, coordinateSystem[0].z);
	glVertex3d(coordinateSystem[2].x, coordinateSystem[2].y, coordinateSystem[2].z);
	// Z axis
	glColor3f(0.0f, 0.0f, 1.0f); // Blue
	glVertex3d(coordinateSystem[0].x, coordinateSystem[0].y, coordinateSystem[0].z);
	glVertex3d(coordinateSystem[3].x, coordinateSystem[3].y, coordinateSystem[3].z);
	glEnd();
}

vector<vector<vec3>> CreateGrid(int count, float distance){

    vector<vector<vec3>> grid;
    grid[i].resize(4);


    float maxDistance= distance*count;


    for(int i=0;i<4;i++){
        grid[i][0]=vec3(i*distance,-0.1f,0);
        grid[i][1]=vec3(i*distance,-0.1f,maxDistance);
        grid[i][2]=vec3(0,-0.1f,i*distance);
        grid[i][3]=vec3(maxDistance,-0.1f,i*distance);
    }
    return grid;

}




void RenderGrid(vector<vector<vec3>> grid){

glLineWidth(1);
glColor3f(green.r,green.g,green.b);

glBegin(GL_LINES);
for(int i=0;i<grid[0].size();i++){
    glVertex3f(grid[i][0].x,grid[i][0].y,grid[i][0].z);
    glVertex3f(grid[i][1].x,grid[i][1].y,grid[i][1].z);
    glVertex3f(grid[i][2].x,grid[i][2].y,grid[i][2].z);
    glVertex3f(grid[i][3].x,grid[i][3].y,grid[i][3].z);
}

glEnd();

}



vector<vector<vec3>> CreateRoad(float roadwayWidth, float roadwLength, float stripeWidth, float stripeLength, float stripeOffset){


vector<vector<vec3>> road;
road.resize(2);

road[0].resize(4);

for(int i=0;i<road[0].size();i++){
    road[0][0]=vec3(0,0,0);
    road[0][1]=vec3(roadwayWidth,0,0);
    road[0][2]=vec3(roadwayWidth,0,roadwaylength);
    road[0][3]=vec3(0,0,roadwaylength);
}


int stripeCount=(int)(roadwaylength)/(stripeLength+stripeOffset);
int currentStripeOffset=0;


road[1].resize(stripeCount*4);

for(int i=0;i<stripeCount*4;i+=4){

road[1][i]=translate(vec3((roadwayWidth/2.f)-(stripeWidth/2/f),0.1f,currentStripeOffset))*vec3(0,0,0);
road[1][i+1]=translate(vec3((roadwayWidth/2.f)-(stripeWidth/2/f),0.1f,currentStripeOffset))*vec3(roadwayWidth,0,0);
road[1][i+2]=translate(vec3((roadwayWidth/2.f)-(stripeWidth/2/f),0.1f,currentStripeOffset))*vec3(roadwayWidth,0,roadwaylength);
road[1][i+3]=translate(vec3((roadwayWidth/2.f)-(stripeWidth/2/f),0.1f,currentStripeOffset))*vec3(0,0,roadwaylength);

currentStripeOffset+=stripeLength+stripeOffset;

}

return road;

}


void RenderRoad(vector<vector<vec3>> road){

glColor3f(gray.r,gray.g,gray.b);
DrawPolygon(road[0]);


glColor3f(white.r,white.g,white.b);

glBegin(GL_POLYGON);
vector<vec3> poly;
for(int i=0;i<road[1].size();i++){
    poly[0]=road[1][i];
    poly[1]=road[1][i+1];
    poly[2]=road[1][i+2];
    poly[3]=road[1][i+3];
    DrawPolygon(poly);

}

glEnd();

}


void CreateCircle(int edgeCount, float radius){
    vector<vec3> motor;

    float delta=M_PI/2*radius;

  for(int i=0;i<egdeCount;i++){


  }

}



void CreateGUISquare(){
    
vector<vector<vec3>> square;
square.resize(4);


for(int i=0;i<square.size();i++){
    square[0][0]=vec3(0,0,0);
    square[0][1]=vec3(1,0,0);
    square[0][2]=vec3(1,1,0);
    square[0][3]=vec3(0,1,0);

}
    return square;

}

vector<vector<vec3>> grid;
vector<vector<vec3>> road;

void  OnLoad(){
   

}



void display(void)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(80.f, 16.f / 9.f, 0.1f, 50.f);
	gluLookAt(
		MotorPosition.x, MotorPosition.y, MotorPosition.z,
		LookAt_vector.x, LookAt_vector.y, LookAt_vector.z,
		LookUp_vector.x, LookUp_vector.y, LookUp_vector.z
	);
	drawCoordinates();

    OnLoad();

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glDisable(GL_DEPTH_TEST);



	glEnable(GL_DEPTH_TEST);

	glutSwapBuffers();
}

void timer(int v)
{
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(
		MotorPosition.x, MotorPosition.y, MotorPosition.z,
		LookAt_vector.x, LookAt_vector.y, LookAt_vector.z,
		LookUp_vector.x, LookUp_vector.y, LookUp_vector.z
	);


	glutTimerFunc(1000 / FPS, timer, v);
	glutPostRedisplay();
}

void reshape(GLsizei width, GLsizei height)
{
	if (height * ratio <= width)
		width = ratio * height;
	else
		height = width / ratio;
	glViewport(0, 0, width, height);
}

void PrintVector(vec3 vec)
{
	printf("%.2f %.2f %.2f\n", vec.x, vec.y, vec.z);
}

void MoveForward()
{
	mat4x4 mt;
	vec3 v = LookAt_vector - MotorPosition;
	v = normalize(v);
	v.y = 0.f;
	v = v * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), v);

	LookAt_vector = mt * LookAt_vector;
	MotorPosition = mt * MotorPosition;
}

void MoveBackward()
{
	mat4x4 mt;
	vec3 v = LookAt_vector - MotorPosition;
	v.y = 0.f;
	v = normalize(v);

	v = -v * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), v);
	LookAt_vector = mt * LookAt_vector;
	MotorPosition = mt * MotorPosition;
}

void MoveLeft()
{
	mat4x4 mt;
	vec3 f = LookAt_vector - MotorPosition;
	vec3 w = cross(LookUp_vector, f);

	w = normalize(w);
	w = w * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), w);

	MotorPosition = mt * MotorPosition;
	LookAt_vector = mt * LookAt_vector;
}

void MoveRight()
{
	mat4x4 mt;
	vec3 f = LookAt_vector - MotorPosition;
	vec3 w = cross(LookUp_vector, f);

	w = normalize(w);
	w = -w * (currentSpeed * (float)MOVING_CONST);

	mt = translate(mat4x4(1.f), w);

	MotorPosition = mt * MotorPosition;
	LookAt_vector = mt * LookAt_vector;
}

void TurnLeft()
{
	mat4x4 mt, identityMat, mt1, mt2, mtr;

	identityMat = mat4x4(1.f);
	mt1 = translate(identityMat, vec3(MotorPosition.x, MotorPosition.y, MotorPosition.z));
	mtr = rotate(identityMat, ROTATION_CONST, vec3(0.f, 1.f, 0.f));
	mt2 = translate(identityMat, vec3(-MotorPosition.x, -MotorPosition.y, -Motorosition.z));

	mt = mt1 * mtr * mt2;
	LookAt_vector = mt * LookAt_vector;

	arrowRotate += ROTATION_CONST;
}

void TurnRight()
{
	mat4x4 mt, identityMat, mt1, mt2, mtr;

	identityMat = mat4x4(1.f);
	mt1 = translate(identityMat, vec3(MotorPosition.x, MotorPosition.y, MotorPosition.z));
	mtr = rotate(identityMat, -ROTATION_CONST, vec3(0.f, 1.f, 0.f));
	mt2 = translate(identityMat, vec3(-MotorPosition.x, -MotorPosition.y, -MotorPosition.z));

	mt = mt1 * mtr * mt2;
	LookAt_vector = mt * LookAt_vector;

	arrowRotate -= ROTATION_CONST;
}

void TurnUp()
{
	mat4x4 mt, mt1, mt2, mtr;
	vec3 f = LookAt_vector - MotorPosition;
	vec3 w = cross(f, LookUp_vector);

	w = normalize(w);

	if (upDownAngle + ROTATION_CONST < (float)M_PI_2)
	{
		mt1 = translate(mat4x4(1.f), vec3(-MotorPosition.x, -MotorPosition.y, -MotorPosition.z));
		mtr = rotate(mat4x4(1.f), ROTATION_CONST, w);
		mt2 = translate(mat4x4(1.f), vec3(MotorPosition.x, Motorosition.y, MotorPosition.z));

		mt = mt2 * mtr * mt1;

		LookAt_vector = mt * LookAt_vector;

		upDownAngle += ROTATION_CONST;
	}
}

void TurnDown()
{
	mat4x4 mt, mt1, mt2, mtr;
	vec3 f = LookAt_vector - Motorosition;
	vec3 w = cross(f, LookUp_vector);

	w = normalize(w);

	if (upDownAngle - ROTATION_CONST > (float)-M_PI_2)
	{
		mt1 = translate(mat4x4(1.f), vec3(-MotorPosition.x, -MotorPosition.y, -MotorPosition.z));
		mtr = rotate(mat4x4(1.f), -ROTATION_CONST, w);
		mt2 = translate(mat4x4(1.f), vec3(MotorPosition.x, MotorPosition.y, MotorPosition.z));

		mt = mt2 * mtr * mt1;

		LookAt_vector = mt * LookAt_vector;
		// LookUp_vector = mt * LookUp_vector;

		upDownAngle -= ROTATION_CONST;
	}
}

void SpeedUp()
{
	if (currentSpeed < 5)
		++currentSpeed;
}

void SpeedDown()
{
	if (currentSpeed > 0)
		--currentSpeed;
}

void initGL(void)
{
	glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
	glShadeModel(GL_FLAT);
	glEnable(GL_DEPTH_TEST);
}

void mousePress(int button, int state, int x, int y)
{
	switch (button)
	{
	case GLUT_LEFT_BUTTON:
		if (state == GLUT_DOWN)
		{
			//FUNKCIJA
		}
		break;
	case GLUT_RIGHT_BUTTON:
		if (state == GLUT_DOWN)
		{
			//FUNKCIJA
		}
		break;
	default:
		break;
	}
}

void keyPress(unsigned char key, int x, int y)
{


	switch (key)
	{
	case 27: //ESC key
		exit(0);
		break;
	case 'w':
		MoveForward();
		break;
	case 's':
		MoveBackward();
		break;
	case 'a':
		//FUNCTION
		MoveLeft();
		break;
	case 'd':
		//FUNCTION
		MoveRight();
		break;
	case 'u':
		SpeedUp();
		break;
	case 'j':

		SpeedDown();
		break;
	case 52:

		TurnLeft();
		break;
	case 54:

		TurnRight();
		break;
	case 50:
		TurnDown();
		break;
	case 56:
		TurnUp();
		break;
	}

}

/*--------------------------------------------------*/

int main(int argc, char** argv)
{
	glutInit(&argc, argv);

	glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_STENCIL);
	glutInitWindowSize(height * ratio, height);
	glutInitWindowPosition(150, 50);
	glutCreateWindow(title);
	createCoordinates();

	glutDisplayFunc(display);
	glutTimerFunc(100, timer, 0);
	glutReshapeFunc(reshape);

	glutMouseFunc(mousePress);
	glutKeyboardFunc(keyPress);

	initGL();
	glutMainLoop();

	return 0;
}

