#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define INF -1
#define NILL -1
#define TRUE 1
#define FALSE 0

typedef struct ustanova
{
    int x;
    int y;
} Ustanova;


int jeManji ( int x, int y )
{
    if ( x == INF ) return FALSE;
    if ( y == INF ) return TRUE;

    return x < y;
}

int zbir ( int x, int y )
{
    if ( x == INF || y == INF ) return INF;

    return x + y;
}

int main ()
{
    int n;
    scanf ( "%d", &n );

    double **graf = ( double** ) malloc ( n * sizeof ( double* ) );
    double **rast = ( double** ) malloc ( n * sizeof ( double* ) );
    int **pret = ( int** ) malloc ( n * sizeof ( int* ) );

    for ( int i = 0; i < n; i++ )
    {
        graf[ i ] = ( double* ) malloc ( n * sizeof ( double ) );
        rast[ i ] = ( double* ) malloc ( n * sizeof ( double ) );
        pret[ i ] = ( int* ) malloc ( n * sizeof ( int ) );
    }

    // inicijalizacija
    for ( int i = 0; i < n; i++ )
        for ( int j = 0; j < n; j++ )
        {
            graf[ i ][ j ] = rast[ i ][ j ] = INF;
            pret[ i ][ j ] = FALSE;
        }
    

    // unos ustanova
    Ustanova ustanove[n];
    for ( int i = 0; i < n; i++ )
    {
        int x, y;
        scanf ( "%d%d", &x, &y );

        ustanove[ i ].x = x;
        ustanove[ i ].y = y;
    }

    // unos u graf
    for ( int i = 0; i < n; i++ )
    {
        int x1 = ustanove[ i ].x;
        int y1 = ustanove[ i ].y;
        for ( int j = 0; j < n; j++ )
        {
            int x2 = ustanove[ j ].x;
            int y2 = ustanove[ j ].y;

            graf[ i ][ j ] = graf[ j ][ i ] = rast[ i ][ j ] = rast[ j ][ i ] = sqrt ( pow ( x1 - x2, 2) + pow ( y1 - y2, 2 ) );
            pret[ i ][ j ] = i;
            pret[ j ][ i ] = j;
        }
        graf[ i ][ i ] = rast[ i ][ i ] = 0;
    }

    // broj postojecih veza
    int m;
    scanf ( "%d", &m );

    for ( int i = 0; i < m; i++ )
    {
        int u, v;
        scanf ( "%d%d", &u, &v );
        
        graf[ u ][ v ] = graf[ v ][ u ] = rast[ u ][ v ] = rast[ v ][ u ] = 0;
        pret[ u ][ v ] = u;
        pret[ v ][ u ] = v;
    }

        
    for ( int k = 0; k < n; k++ )
        for ( int i = 0; i < n; i++ )
            for ( int j = 0; j < n; j++ )
                if( jeManji ( zbir ( rast[ i ][ k ], rast[ k ][ j ] ), rast[ i ][ j ] ))
                {
                    rast[ i ][ j ] = rast[ i ][ k ] + rast[ k ][ j ];
                    pret[ i ][ j ] = pret[ k ][ j ];
                }
            
    double *raspon = ( double* ) malloc ( n * sizeof ( double ) );

    for ( int i = 0; i < n; i++ )
    {
        raspon[ i ] = rast[ i ][ 0 ];
        for ( int j = 0; j < n; j++ )
        {
            if ( jeManji ( rast[ i ][ j ], raspon[ i ] ) && rast[ i ][ j ] != 0) raspon[ i ] = rast[ i ][ j ];
        }
    }

    double duzina = 0;
    for ( int i = 0; i < n; i++ )
    {
        duzina += raspon[ i ];
    }

    printf ( "%.2f\n", duzina );

    return 0;
}
