#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#include<limits.h>

#define INF INT_MAX
#define NEDEFINISANO -1


typedef struct element{
    double x;
    double y;
}element;


double euklidsko_rastojanje(double x1, double y1, double x2, double y2){

    return sqrt( (x1 - x2)*(x1 - x2) + (y1 - y2)*(y1 - y2));
}

double najmanjiSledeciPut(int index_tr_elementa, int *obradjeni, int n, element *elementi){

    double najmanje_trenutno_rastojanje = INF;

    for(int i = 0; i < n; i++){

            if(obradjeni[i] == NEDEFINISANO && i != index_tr_elementa){

                double euklid = euklidsko_rastojanje(elementi[index_tr_elementa].x, elementi[index_tr_elementa].y, elementi[i].x, elementi[i].y);

                if(najmanje_trenutno_rastojanje > euklid)
                 najmanje_trenutno_rastojanje = euklid;
            }

        }
    
    return najmanje_trenutno_rastojanje;

}


void mst( int *obradjeni, double *duzina_novog_kabla, int n, element *elementi){

    //ideja je da krenemo od neke putanje koja vec postoji i dodajemo najoptimalnije moguce opcije
    //u pitanju je Primov algoritam za pravljenje Minimalnog razapinjuceg stabla
    for(int i = 0; i < n; i++){
       
       if(obradjeni[i] != NEDEFINISANO){
         
         (*duzina_novog_kabla) += najmanjiSledeciPut(i, obradjeni, n, elementi);
           obradjeni[i] = 1;


       }
    }
}

int main(){

    int n;
    scanf("%d", &n);

    element *elementi = (element*)malloc(n * sizeof(element));
    int *obradjeni = (int*)malloc(n * sizeof(int));

    for(int i = 0; i < n; i++)
      obradjeni[i] = NEDEFINISANO;


    //ucitavanje vrednosti koordinata ustanova
    for(int i = 0; i < n; i++){
        
            double x, y;
            scanf("%lf%lf", &x, &y);
            elementi[i].x = x;
            elementi[i].y = y;
        }

    int k;
    scanf("%d", &k);

    while(k--){

        //ucitavanje povezanosti
        int u1, u2;
        scanf("%d%d", &u1, &u2);

        //graf[u1][u2] = graf[u2][u1] = rastojanja[u1][u2] = rastojanja[u2][u1] = euklidsko_rastojanje(elementi[u1].x, elementi[u1].y, elementi[u2].x, elementi[u2].y);
        obradjeni[u1] = obradjeni[u2] = 1;
    }

    double ukupna_duzina_kabla = 0.0;
    mst(obradjeni, &ukupna_duzina_kabla, n, elementi);

    printf("%.2f\n", ukupna_duzina_kabla);

    return 0;
    }

