/*
    -od datih koordinata formirati matricu povezanosti
    -naci MST 
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define INF -1
#define VISITED 1
#define UNVISITED 0

typedef struct pair
{
    float x, y;
}Pair;

float getSum(float x, float y);

int isLesserThan(float x, float y);

float getDistanceBetweenPoints(Pair a, Pair b);

void printMatrix(float **matrix, int n);

int findOptimal(float *distances, float *visited, int n);

int main()
{
    int i, j;
    int n;
    scanf("%d", &n);

    Pair *pairs = (Pair*)malloc(n * sizeof(Pair));

    float **connections = (float**)malloc(n * sizeof(float*));
    float *ancestors = (float*)malloc(n * sizeof(float));
    float *distances = (float*)malloc(n * sizeof(float));
    float *visited = (float*)malloc(n * sizeof(float));
    
    for(i = 0; i < n; i++)
    {
        connections[i] = (float*)malloc((n + 1) * sizeof(float));

        ancestors[i] = INF;
        distances[i] = INF;
        visited[i] = UNVISITED;

        float x, y;
        scanf("%f%f", &x, &y);

        pairs[i].x = x;
        pairs[i].y = y;
    }

    //formiranje veza
    for(i = 0; i < n; i++)
    {
        for(j = 0; j < n; j++)
        {
            connections[i][j] = connections[j][i] = getDistanceBetweenPoints(pairs[i], pairs[j]);
        }
    }

    int k;
    scanf("%d", &k);

    for(i = 0; i < k; i++)
    {
        int a, b;
        scanf("%d%d", &a, &b);

        connections[a][b] = connections[b][a] = distances[a] = distances[b] = 0;
        ancestors[a] = b;
        ancestors[b] = a;
    }

    //printMatrix(connections, n);
    
    int u;
    while((u = findOptimal(distances, visited, n)) != INF)
    {
        visited[u] = VISITED;

        int v;
        for(v = 0; v < n; v++)
        {
            if(visited[v] == UNVISITED && isLesserThan(connections[u][v], distances[v]))
            {
                distances[v] = connections[u][v];
                ancestors[v] = u;
            }
        }
    }

    float totalDistance = 0;

    for(i = 0; i < n; i++)
    {
        totalDistance += distances[i];
    }

    printf("%.2f\n", totalDistance);

    return 0;
}


float getSum(float x, float y)
{
    if(x == INF)
        return INF;
    if(y == INF)
        return INF;
    return x + y;
}

int isLesserThan(float x, float y)
{
    if(x == INF)
        return y;
    if(y == INF)
        return y;
    return x < y;
}

float getDistanceBetweenPoints(Pair a, Pair b)
{
    return sqrt((a.x - b.x) * (a.x - b.x)) + sqrt((a.y - b.y) * (a.y - b.y));
}

void printMatrix(float **matrix, int n)
{
    int i, j;
    for(i = 0; i < n ; i++)
    {
        for(j = 0; j < n; j++)
            printf("%.2f ", matrix[i][j]);
        printf("\n");
    }
}


int findOptimal(float *distances, float *visited, int n)
{
    int minNode = INF;
    float min = INF;

    int i;
    for(i = 0; i < n; i++)
    {
        if(visited[i] == UNVISITED && isLesserThan(distances[i], min))
        {
            min = distances[i];
            minNode = i;
        }
    }

    return minNode;
}