#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct tacka{
    float x, y;
}Tacka;

int jeManji(int x, int y){
    if(x == -1) return 0;
    if(y == -1) return 1;

    return x < y;
}

int dajNajmanji(int n, int *obidjen, float *d){
    int min = -1, minCvor = -1;

    for(int i = 0; i < n; i++){
        if(obidjen[i] == 0 && jeManji(d[i], min)){
            min = d[i];
            minCvor = i;
        }
    }

    return minCvor;
}

float euklidsko_rastojanje(float x1, float x2, float y1, float y2){
    return sqrt((x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
}

void relax(float **graf, int n, int u, int v, float* d, int *pret){
    if(jeManji(graf[u][v] + d[u], d[v])){
        d[v] = graf[u][v] + d[u];
        pret[v] = u;
    }
}

void dijkstra(float **graf, int n, float *d, int *obidjen, int *pret){
    for(int i = 0; i < n; i++){
        int u = dajNajmanji(n, obidjen, d);
        obidjen[u] = 1;
    
        for(int v = 0; v < n; v++){
            if(graf[u][v] != -1 && obidjen[v] == 0){
                relax(graf, n, u, v, d, pret);
            }
        }
    }
}

float saberi(float *d, int n){
    float suma = 0;
    for(int i = 0; i < n; i++){
        suma += d[i];
    }
    return suma;
}

void reset(float *d, int *obidjen, int *pret, int n){
    for(int i = 0; i < n; i++){
        d[i] = -1;
        obidjen[i] = 0;
        pret[i] = -1;
    }
}

int main(){
    int n;
    scanf("%d", &n); 

    float **graf = (float**)malloc(sizeof(float) * n);
    for(int i = 0; i < n; i++){
        graf[i] = (float*)malloc(sizeof(float) * n);
    }

    Tacka *tacke = (Tacka*)malloc(sizeof(Tacka) * n);
    for(int i = 0; i < n; i++){
        Tacka t;
        scanf("%f%f", &(t.x), &(t.y));
        tacke[i] = t;
    }

    for(int i = 0; i < n; i++){
        for(int j = 0; j < n; j++){
            graf[i][j] = graf[j][i] = euklidsko_rastojanje(tacke[i].x, tacke[j].x, tacke[i].y, tacke[j].y);
        }
    }

    // printf("Graf pre:\n");
    // for(int i = 0; i < n; i++){
    //     for(int j = 0; j < n; j++){
    //         printf("%.2f ", graf[i][j]);
    //     }
    //     putchar('\n');
    // }

    int k;
    scanf("%d", &k);
    for(int i = 0; i < k; i++){
        int a, b;
        scanf("%d%d", &a, &b);
        graf[a][b] = graf[b][a] = 0; //nema trosak
    }

    float *d = (float*)malloc(sizeof(float) * n);
    int *obidjen = (int*)malloc(sizeof(int) * n);
    int *pret = (int*)malloc(sizeof(int) * n);

    for(int i = 0; i < n; i++){
        d[i] = -1;
        obidjen[i] = 0;
        pret[i] = -1;
    }

    float *sume = (float*)malloc(sizeof(float) * n);
    for(int i = 0; i < n; i++){
        d[i] = 0;
        dijkstra(graf, n, d, obidjen, pret);
        sume[i] = saberi(d, n);
        reset(d, obidjen, pret, n);
        //printf("%f ", sume[i]);
    }

    float minSuma = -1;
    for(int i = 0; i < n; i++){
        if(minSuma == -1 || sume[i] < minSuma){
            minSuma = sume[i];
        }
    }

    printf("%.2f\n", minSuma);

    return 0;
}