#include<stdio.h>
#include<stdlib.h>
#include<math.h>

#define INF 1e9
#define TRUE 1
#define FALSE 0

typedef struct koordinate{
    double x;
     double y;
}Koordinate;

void stampaj(double **graf, int n){
     for(int i=0;i<n;i++){
        for(int j=0;j<n;j++){
            printf("%lf  ", graf[i][j]);
        }
        printf("\n");
    }
}

int minkey(int *mstset, double *key, int n){
    double min = INF, index = -1;
     for(int i=0;i<n;i++){
        if(!mstset[i] && key[i]!= INF && key[i]<min){
            min = key[i];
            index = i;
        }
     }
     return index;
}

double prim(double **graf, int n){
    double *key =(double*)malloc(n*sizeof(double));
    int *mstset =(int*)malloc(n*sizeof(int));
    double sum = 0;

    for(int i=0;i<n;i++){
        key[i] = INF;
        mstset[i] = FALSE;
    }

    key[0] = 0;

     for(int i=0;i<n;i++){

        int u = minkey(mstset, key, n);
        mstset[u] = TRUE;
    
         for(int v=0;v<n;v++){
            if(!mstset[v] && key[v]!=INF && key[u]>graf[u][v]+key[v] ){
                key[u] = key[v]+graf[u][v];
            }
         }
     }

    for(int i=0;i<n;i++){
        sum+=key[i];
     }
   
     return sum;
}

int main(){
    int n;
    scanf("%d", &n);
    double **graf = (double**)malloc(n*sizeof(double*));
    Koordinate koUstanova[n];
   for(int i=0;i<n;i++){
        graf[i]=(double*)malloc(n*sizeof(double));
    }
    for(int i=0;i<n;i++){
        for(int j=0;j<n;j++){
            graf[i][j] = INF;
        }
    }

    for(int i=0;i<n;i++){
       scanf("%lf%lf", &koUstanova[i].x, &koUstanova[i].y);
    }

    for(int i=0;i<n;i++){
        for(int j=0;j<n;j++){
            int dx = koUstanova[i].x - koUstanova[j].x;
            int dy = koUstanova[i].y - koUstanova[j].y;

            graf[i][j] = sqrt(dx*dx + dy*dy);
            graf[j][i]=graf[i][j];

        }
    }

    int k;
    scanf("%d", &k);
    int a, b;
       for(int i=0;i<k;i++){
        scanf("%d%d", &a,&b);
        graf[a][b] = graf[b][a] = 0.00;
       }

    //stampaj(graf, n);
    printf("%lf ", prim(graf, n));
    
}
