#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define TRUE 1
#define FALSE 0
#define INF -1
#define NEDEFINISANO -1

typedef struct {
    double x;
    double y;
}ustanova_cvor;

typedef struct {
    int a;
    int b;
}postojeca_veza;

int **graf;
double *key;
int *obidjeni;
postojeca_veza *vec_povezani;
ustanova_cvor *ustanove;

double euklidsko_rastojanje(int x1, int y1, int x2, int y2) {
    return math.sqrt( (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
}

int jeManji(int x, int y) {
    if(x == INF) return FALSE;
    if(y == INF) return TRUE;
    return x < y;
}

int dajNajboljeg() {
    int min_cvor = NEDEFINISANO;
    double min_key = INF;

    for(int i = 0; i < n; i ++) {
        if(!obidjeni[i] && jeManji(key[i], min_key)) {
            min_cvor = i;
            min_key = key[i];
        }
    }
    
    return i;
}

int prim() {
    
    for(int i = 0; i < n; i++) {
        key[i] = NEDEFINISANO;
        obidjeni[i] = FALSE;
    }

    double ukupan_put = 0;
    key[0] = 0;

    while((u = dajNajboljeg()) != NEDEFINISANO) {
        obidjeni[u] = TRUE;
        for(int v = 0; v < n; v++) {
            double rastojanje = euklidsko_rastojanje(u, 0, u, v);
            if(graf[u][v] != NEDEFINISANO && jeManji(key[v], rastojanje)) {
                key[v] = rastojanje;
                ukupan_put += rastojanje;
            }
        }
    }

    return ukupan_put;
}

int main() {
    
    int n, k;
    scanf("%d", &n);

    for(int i = 0; i < n; i++) {
        key = (double *)malloc(n * sizeof(double));
        obidjeni = (int *)malloc(n * sizeof(int));
        graf[i] = (int **)malloc(n * sizeof(int));
        ustanove[i] = (ustanova_cvor *)malloc(n * sizeof(ustanova_cvor));

        for(int j = 0; j < n; j++) {
            graf[i] = (int *)malloc(n * sizeof(int));
            graf[i][j] = NEDEFINISANO;
        }
    }

    for(int i = 0; i < n ; i++) {
        int x, y;
        scanf("%f%f", &x, &y);
        ustanove[i].x = x;
        ustanove[i].y = y;
    }
    //treba napraviti graf od ovoga

    scanf("%d", &k);

    for(int j = 0; j < k; j++){
        int a, b;
        scanf("%d%d", &a, &b);
        postojeca_veza[j].a = a;
        postojeca_veza[j].b = b;
    }

    return 0;
}