#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define INF 1000000
#define NILL -1
#define TRUE 1
#define FALSE 0


double nadjiMinimum(int *obidjen, double *d, int n){
    double min = INF;
    int minCvor = NILL;

    for(int  i = 0; i < n; i++){
        if(obidjen[i] == FALSE && d[i] < min){
            min = d[i];
            minCvor = i;
        }
    }

    return minCvor;
}

void relax(double **graf, int *pret, double *d, int u, int v){
    if(d[v] > d[u] + graf[u][v]){
        d[v] = d[u] + graf[u][v];
        pret[v] = u;
    }
}

double algoritam(double **graf, int *obidjen, int *pret, double *d, int n, int s){
    d[s] = 0;

    double ukupno = 0;

    for(int i = 0; i < n; i++){
        int u = nadjiMinimum(obidjen, d, n);
        if(u == NILL){
            break;
        }
        obidjen[u] = TRUE;
        ukupno += d[u];
        for(int v = 0; v < n; v++){
            if(graf[u][v] != INF && obidjen[v] == FALSE){
                relax(graf, pret, d, u, v);
            }
        }
    }

    return ukupno;

}

int main(){

    int n, x, y, k, a,b;

    scanf("%d", &n);

    double **graf = (double **)malloc(n * sizeof(double*));
    int *obidjen = (int *)malloc(n * sizeof(int));
    int *pret = (int *)malloc(n * sizeof(int));
    double *d = (double *)malloc(n * sizeof(double));
    int *korX = (int *)malloc(n * sizeof(int));
    int *korY = (int *)malloc(n * sizeof(int));
    

    for(int i = 0; i < n; i++){
        scanf("%d%d", &x, &y);
        korX[i] = x;
        korY[i] = y;

    }



    for(int i = 0; i < n; i++){

        graf[i] = (double *)malloc(n * sizeof(double));

        for(int  j = 0; j < n; j++){
            graf[i][i] = INF;              
        }


        obidjen[i] = FALSE;
        pret[i] = NILL;
        d[i] = INF;

    }

    for(int i = 0; i < n; i++){

        for(int j = 0; j < n; j++){

            graf[i][j] = sqrt(pow((korX[i] - korX[j]),2) + pow((korY[i] - korY[j]),2));
            graf[j][i] = sqrt(pow((korX[i] - korX[j]),2) + pow((korY[i] - korY[j]),2));
            graf[i][i] = INF;  
        }
    }
    


    scanf("%d", &k);

    for(int i = 0; i < k; i++){
        scanf("%d%d", &a, &b);
        graf[a][b] = 0;
        graf[b][a] = 0;      
        
    }


    // for(int i = 0; i < n; i++){
    //     for(int j = 0; j < n; j++){
    //         printf("%f\n", graf[i][j]);
    //     }
    // }


    double kabloviM = algoritam(graf, obidjen, pret, d, n, 0);
        
    printf("%.2f\n", kabloviM);


}