#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef enum color {WHITE, GRAY, BLACK} COLOR;

#define new(x, n) (x*) malloc ((n) * sizeof(x))
#define UNDEFINED -1
#define CONNECTED 1

void dfs_visit(float **graph, int* d_djs, int* super, COLOR *color, int u, int n, int super_or){
    if (d_djs[u] != UNDEFINED) return;
    super[u] = super_or;
    for (int v=0; v<n; v++){
        if (graph[u][v] == UNDEFINED || color[v] == BLACK) continue;
        if (color[v] == WHITE){
            dfs_visit(graph, d_djs, super, color, v, n, super_or);
            color[v] = GRAY;
        }            
    }
    color[u] = BLACK;
}

int left_less(float a, float b){
    if (a == UNDEFINED) return 0;
    if (b == UNDEFINED) return 1;
    return a < b;
}

int minimal(float *d, COLOR *color, int n){
    float min_value = UNDEFINED;
    int min_node = UNDEFINED;
    
    for (int v=0; v<n; v++){
        if (color[v] == GRAY && left_less(d[v], min_value)){
            min_value = d[v];
            min_node = v;
        }
    }
    return min_node;
}

void relax(float **graph, float *d, int *prev, int u, int v, int i, int j){
    if (d[u] == UNDEFINED) return;

    if (left_less(graph[i][j], d[v])){
        d[v] = graph[i][j];
        prev[v] = u;
    }
}

void prim(float **graph, float *d, int *prev, COLOR *color, int* super, int super_counter, int n, float *total){
    while(1){
        int u = minimal(d, color, super_counter);
        if (u==UNDEFINED) return;

        color[u] = BLACK;
        (*total) += d[u];
        for (int v=0; v<super_counter; v++){
            if (color[v] == BLACK) continue;
            for (int i=0; i<n; i++){
                if (super[i] != u) continue;
                for (int j=0; j<n; j++){
                    if (super[j] != v) continue;
                    if (graph[i][j] == UNDEFINED) continue;
                    relax(graph, d, prev, u, v, i, j);
                }
            }
            if (color[v] == WHITE && d[v] != UNDEFINED) color[v] = GRAY;
        }
    }
}

int main(){
    int n;
    scanf("%d", &n);

    float **all_graph = new(float*, n);
    float *x = new(float, n);
    float *y = new(float, n);

    for (int i=0; i<n; i++){
        scanf("%f %f", &x[i], &y[i]);
        all_graph[i] = new (float, n);
    }

    for (int i=0; i<n; i++){
        for (int j=0; j<n; j++){
            float distance = sqrt((x[i] - x[j]) * (x[i] - x[j]) + (y[i] - y[j]) * (y[i] - y[j]));
            all_graph[i][j] = distance;
            all_graph[j][i] = distance;
        }
    }
    int k;
    scanf("%d", &k);

    float **dfs_graph = new(float*, n);

    for (int i=0; i<n; i++){
        dfs_graph[i] = new (float, n);
        for (int j=0; j<n; j++){
            dfs_graph[i][j] = UNDEFINED;
        }
    }
    for (int i=0; i<k; i++){
        int one, two;
        scanf("%d %d", &one, &two);
        dfs_graph[one][two] = CONNECTED;
        dfs_graph[two][one] = CONNECTED;
    }

    int *super = new(int, n);
    int *d_djs = new(int, n);
    COLOR *color = new(COLOR, n);

    for (int i=0; i<n; i++){
        color[i] = WHITE;
        super[i] = UNDEFINED;
        d_djs[i] = UNDEFINED;
    }

    int super_counter = 0;
    for (int i=0; i<n; i++){
        if (color[i] == WHITE){
            color[i] = GRAY;
            dfs_visit(dfs_graph, d_djs, super, color, i, n, super_counter);
            super_counter++;
        }
    }

    float *d = new(float, super_counter);
    int *prev = new(int, super_counter);
    COLOR *color_prim = new(COLOR, super_counter);

    for (int i=0; i<super_counter; i++){
        d[i] = UNDEFINED;
        prev[i] = UNDEFINED;
        color_prim[i] = WHITE;
    }

    float total_new = 0;
    d[0] = 0;
    color_prim[0] = GRAY;
    prim(all_graph, d, prev, color_prim, super, super_counter, n, &total_new);

    printf("%.2f\n", total_new);
}