#include <stdio.h>
#include <stdlib.h>
#include <math.h>



typedef struct cvor{
    float x;
    float y;
} cvor;

typedef struct ust{
    int n;
    cvor** niz;
} ust;

typedef struct cvorID{
    int sused;
    struct cvorID* sledeci;
} cvorID;

typedef struct graf{
    int n;
    cvorID** niz;
} graf;

cvor* napraviCvor(float x, float y){
    cvor* novi = (cvor*)malloc(sizeof(cvor));
    novi->x = x;
    novi->y = y;

    return novi;
}

ust* napraviUstanove(int n){
    ust* u = (ust*)malloc(sizeof(ust));
    u->n = n;
    u->niz = (cvor**)malloc(u->n * sizeof(cvor*));

    for(int i=0 ; i<u->n ; i++){
        float x, y;
        printf("Unesi X i Y koordinatu za ustanovu: ");
        scanf("%f %f", &x, &y);
        u->niz[i] = napraviCvor(x,y);
    }

    return u;
}

void stampaUst(ust* u){
    for(int i=0 ; i<u->n ; i++){
        printf("X: %.2f Y: %.2f\n", u->niz[i]->x, u->niz[i]->y);
    }
}

graf* napraviGraf(int n){
    graf* g = (graf*)malloc(sizeof(graf));
    g->n = n;
    g->niz = (cvorID**)malloc(g->n * sizeof(cvorID*));

    for(int i=0 ; i<g->n ; i++){
        g->niz[i] = NULL;
    }

    return g;
}

void dodajVezu(graf* g, int id, int sused){
    cvorID* novi = (cvorID*)malloc(sizeof(cvorID));
    novi->sused = sused;
    novi->sledeci = g->niz[id];
    g->niz[id] = novi;
}

void stampa(graf* g){
    for(int i=0 ; i<g->n ; i++){
        printf("Ustanova %d je povezana sa: -> ", i);
        cvorID* temp = g->niz[i];
        while(temp){
            printf("sused: %d -> ",temp->sused);
            temp = temp->sledeci;
        }
        printf("NULL\n");
    }
}

float euklidskoRastojanje(float x1, float x2, float y1, float y2){
    return sqrt(pow(abs(x1-x1),2) + pow(abs(y1-y2),2));
}

void prim(graf* g, ust* u){
    int* poseceni = (int*)calloc(g->n, sizeof(int));
    int* dist = (int*)malloc(g->n * sizeof(int));
    int* roditelj = (int*)malloc(g->n * sizeof(int));

    for(int i=0 ; i<g->n ; i++){
        dist[i] = 1000000;
        roditelj[i] = -1;
    }

    dist[0] = 0;
    for(int i=0 ; i<g->n ; i++){
        int min = 1000000;
        int u = -1;
        for(int j=0 ; j<g->n ; j++){
            if(poseceni[j]==0 && dist[j]<min){
                min = dist[j];
                u = j;
            }
        }

        if(u==-1) break;

        poseceni[u] = 1;
        cvorID* temp = g->niz[u];
        while(temp){
            int v = temp->sused;
            //cvor* rs1 = u->niz[u];
            //cvor* rs2 = u->niz[v];
            //int eurs = euklidskoRastojanje(rs1->x,rs2->x,rs1->y,rs2->y);
            if(poseceni[v]==0 && dist[u]<dist[v]){
                /*
                for(int i=0 ; i<g->n ; i++){
                    cvorID* temp = g->niz[i];
                    while(temp){
                        if(i==v && temp->vrednost==u){
                            dist[v] = 0;
                        }else{dist[v] = dist[u]+eurs;}
                        temp = temp->sledeci;
                    }
                    printf("NULL\n");
                }
                */
                dist[v] = dist[u]+temp->sused;
                roditelj[v] = u;
            }
            temp = temp->sledeci;
        }
    }

    int suma = 0;
    for(int i=0 ; i<g->n ; i++){
        suma += dist[i];
    }
    printf("Najmanja duzina kabla da se povezu sve ustanove: %dkm.\n", suma);

    free(poseceni);
    free(roditelj);
    free(dist);
}

int main(){
    int n;
    printf("Unesite broj ustanova: ");
    scanf("%d", &n);
    ust* u = napraviUstanove(n);
    stampaUst(u);

    
    
    graf* g = napraviGraf(n);
    int m;
    printf("Unesite broj povezanih: ");
    scanf("%d", &m);
    for(int i=0 ; i<m ; i++){
        int a,b;
        printf("Unesite broj ustanove a i b: ");
        scanf("%d %d", &a, &b);
        dodajVezu(g,a,b);
        dodajVezu(g,b,a);
    }
    stampa(g);


    graf* g1 = napraviGraf(n);
    for(int i=0 ; i<n ; i++){
        for(int j=0 ; j<n ; j++){
            dodajVezu(g1,i,j);
            dodajVezu(g1,j,i);
        }
    }
    //stampa(g1);
    
    prim(g, u);
    printf("\n\n");
    prim(g1, u);
}