#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define NEDEFINISANO -1
#define INF 11111111
#define TRUE 1
#define FALSE 0

int nadjiNajmanji(double *d, double *posecen, int n)
{
    int minTezina = INF;
    int minCvor = NEDEFINISANO;

    for(int i=0;i<n;i++)
    {
        if(posecen[i] == FALSE && minTezina>d[i])
        {
            minTezina = d[i];
            minCvor = i;
        }
    }

    return minCvor;
}


void relax(double **graf, double *d, double *pret, int trenutni,int sledeci)
{
    if(d[sledeci]>graf[trenutni][sledeci])
    {
        d[sledeci] = graf[trenutni][sledeci];
        pret[sledeci] = trenutni;
    }
}

void prim(double **graf, double *d, double *posecen, double *pret,int n)
{
    d[0] = 0;
    for(int i=0;i<n;i++)
    {
        int trenutniNajmanji = nadjiNajmanji(d,posecen,n);
        if(trenutniNajmanji == NEDEFINISANO) break;
        posecen[trenutniNajmanji] = TRUE;
        for(int sledeci = 0; sledeci<n;sledeci++)
        {
            if(graf[trenutniNajmanji][sledeci]!=INF && posecen[sledeci] == FALSE)
            {
                relax(graf,d,pret,trenutniNajmanji,sledeci);
            }
        }
}
}


int main()
{

    int n;
    scanf("%d",&n);

    double *x = (double*)malloc(n*sizeof(double));
    double *y = (double*)malloc(n*sizeof(double));
    

    for(int i=0;i<n;i++)
    {
        scanf("%lf%lf",&x[i],&y[i]);
    }


    double **graf = (double**)malloc(n*sizeof(double*));
    for(int i=0;i<n;i++)
    {
        graf[i] = (double*)malloc(n*sizeof(double));
    }    



    double *d = (double*)malloc(n*sizeof(double));
    double *posecen = (double*)malloc(n*sizeof(double));
    double *pret = (double*)malloc(n*sizeof(double));

    for(int i=0;i<n;i++)
    {
        for(int j=0;j<n;j++)
        {
            graf[i][j] = INF;
        }
        d[i] = INF;
        pret[i] = NEDEFINISANO;
        posecen[i] = FALSE;
    }

  
    for(int i=0;i<n;i++)
    {
        for(int j=0;j<n;j++)
        {
            if(i==j)
            {
                graf[i][j] = 0;
            }
            else
            {
                double dx = x[i] - x[j];
                double dy = y[i] - y[j];
                graf[i][j] = sqrt(dx*dx+dy*dy);
            }
        }
    }

    int k;
    scanf("%d",&k);
    for(int i=0;i<k;i++)
    {
        int a,b;
        scanf("%d%d",&a,&b);
        graf[a][b] = 0;
        graf[b][a] = 0;
    }

    prim(graf,d,posecen,pret,n);
    double ukupno = 0;
    for(int i=0;i<n;i++)
    {
        ukupno+=d[i];
    }

    printf("%.2lf\n",ukupno);
    return 0;
}
