#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define TRUE 1
#define FALSE 0
#define INF -1

typedef struct ustanova{
    int x;
    int y;
}ustanova;

typedef struct veza{
    int u;
    int v;
    int w;
}veza;

double rastojanje(ustanova u1,ustanova u2)
{
    double dx=u1.x-u2.x;
    double dy=u1.y-u2.y;

    return sqrt(dx*dx+dy*dy);
}

void promeniPripadnost(int *pripadnost,int u,int v,int n)
{
    int trazenaPripadnost=pripadnost[u];
    for(int i=0;i<n;i++)
    {
        if(pripadnost[i]==trazenaPripadnost)
        {
            pripadnost[i]=v;
        }
    }
}

int main()
{
    int n;
    scanf("%d",&n);

    int **graf=(int *)malloc(n*sizeof(int *));
    double *d=(double *)malloc(n*sizeof(int));
    Veza *veze=(int *)malloc(n*sizeof(int));
    int *pripadnost=(int *)malloc(n*sizeof(int));
    int *uvrsteneVeze=(int *)malloc(n*sizeof(int));
    int *ustanove=(int *)malloc(n*sizeof(int));

    for(int i=0;i<n;i++)
    {
        int x,y;
        scanf("%d %d",&x,&y);
        ustanove[i].x=x;
        ustanove[i].y=y;
    }

    for(int i=0;i<n;i++)
    {
        veze[i]=INF;
    }

    int k;
    scanf("%d",&k);

    for(int i=0;i<k;i++)
    {
        int a,b;
        scanf("%d%d",&a,&b);
        veze[i].u=a;
        veze[i].v=b;
        veze[i].w=rastojanje(ustanova[a],ustanova[b]);
    }

    for(int i=0;i<n;i++)
    {
        pripadnost[i]=i;
    }

    for(int i=0;i<n;i++)
    {
        Veza *temp;
        for(int j=i+1;j<n;i++)
        {
            if(veza[i].w<veza[j].w)
            temp=veza[i];
            veza[i]=veza[j];
            veza[j]=temp;
        }
    }

    for(int u=0;i<n;i++)
    {
        for(int v=0;j<n;j++)
        {
            int suma=0;
            if(pripadnost[i]!=pripadnost[v])
            {
                double suma=0;
                promeniPripadnost(pripadnost[i],u,v);
                uvrsteneVeze[i]=TRUE;
                if(uvrsteneVeze[i]==TRUE)
                {
                    suma+=veze[uvrsteneVeze[i]].w;
                }
            }
        }   
    }

    printf("%lf",&suma);
}