#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct ustanova
{
    int redniBroj;
    int x;
    int y;
}ustanova;

typedef struct veza
{
    int u;
    int v;
    double trosak;
}veza;

//trosak postavljanja kabla je euklidsko rastojanje

void promeniPripadnost(int *pripadnost,int n,int x,int y)
{
    int trazenaPripadnost=pripadnost[y];

    for(int i=0;i<n;i++)
    {
        if(pripadnost[i]==trazenaPripadnost)
        {
            pripadnost[i]=x;
        }
    }
}
double MST(int n,int m,veza * sveVeze)
{
    int *pripadnost=(int*)malloc(n*sizeof(int));

    for(int i=0;i<n;i++)
        pripadnost[i]=i;

    double ukupanTrosak=0.0;
    int brojUvrstvenih=0;

    for(int i=0;brojUvrstvenih<n-1;i++)
    {
        if(pripadnost[sveVeze[i].u]!=pripadnost[sveVeze[i].v])
        {
            promeniPripadnost(pripadnost,n,sveVeze[i].u,sveVeze[i].v);
            ukupanTrosak+=sveVeze[i].trosak;
            brojUvrstvenih++;
        }
    }
    return ukupanTrosak;
}

int main()
{
    int n;
    scanf("%d",&n);
    ustanova *ustanove=(ustanova*)malloc(n*sizeof(ustanova));
    int x,y;//u kilometrima
    for(int i=0;i<n;i++)
    {
        scanf("%d %d",&x,&y);
        ustanove[i].x=x;
        ustanove[i].y=y;
        ustanove[i].redniBroj=i;
    }
    int k;
    scanf("%d",&k);
    int maxVeza=(n*(n-1))/2;
    veza * sveVeze=(veza *)malloc(maxVeza*sizeof(veza));
    veza * postojeceVeze=(veza*)malloc(k*sizeof(veza));
    for(int i=0;i<k;i++)
    {
        scanf("%d %d",&x,&y);
        postojeceVeze[i].u=x;
        postojeceVeze[i].v=y;
        postojeceVeze[i].trosak=0.0;
    }

    int br=0;
    for(int i=0;i<n-1;i++)
    {
        for(int j=i+1;j<n;j++)
        {
            veza postojeca=postojeceVeze[br];
            sveVeze[br].u=i;
            sveVeze[br].v=j;
            if(i==postojeca.u && j==postojeca.v)
            {
                sveVeze[br].trosak=0.0;
            }
            else
            {
                sveVeze[br].trosak=sqrt(pow(ustanove[i].x-ustanove[j].x,2)+pow(ustanove[i].y-ustanove[j].y,2));
            }
            br++;
        }
    }

    veza temp;
    for(int i=0;i<n-1;i++)
    {
        for(int j=i+1;j<n;j++)
        {
            if(sveVeze[j].trosak<sveVeze[i].trosak)
            {
                temp=sveVeze[i];
                sveVeze[i]=sveVeze[j];
                sveVeze[j]=temp;
            }
        }
    }

    double dodatiKabal=0;

    dodatiKabal=MST(n,k,sveVeze);

    printf("%.2f\n",dodatiKabal);
}