#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct{
    double x, y;
}Grad;

typedef struct{
    int u, v;
    double rastojanje;
}Veza;

int *roditelj;

double rastojanje(Grad a, Grad b){
    double dx = a.x - b.x;
    double dy = a.y - b.y;
    return sqrt(dx*dx + dy*dy);
}

int find(int x){
    if(roditelj[x] != x)
        roditelj[x] = find(roditelj[x]);
    return roditelj[x];
}

void unite(int a, int b){
    a = find(a);
    b = find(b);
    if(a != b)  
        roditelj[b] = a;
}

int cmp(const void *a, const void *b){
    return ((Veza*)a)->rastojanje - ((Veza*)b)->rastojanje;
}

double mst(Veza *veze, int n){
    roditelj = (int*)malloc(n * sizeof(int));
    for(int i = 0; i < n; i++) roditelj[i] = i;

    qsort(veze, n, sizeof(Veza), cmp);

    double minimalnaDuzina = 0;

    for(int i = 0; i < n; i++){
        int u = veze[i].u;
        int v = veze[i].v;
        if(find(u) != find(v)){
            unite(u, v);
            minimalnaDuzina += veze[i].rastojanje;
        }
    }

    free(roditelj);

    return minimalnaDuzina;
}

int main(){
    int n;
    scanf("%d", &n);

    Grad *gradovi = (Grad*)malloc(n * sizeof(Grad));

    for(int i = 0; i < n; i++){
        scanf("%lf%lf", &gradovi[i].x, &gradovi[i].y);
    }

    Veza *veze = (Veza*)malloc(n * n * sizeof(Veza));

    int k, a, b;
    int **graf = (int**)malloc(n * sizeof(int*));
    for(int i = 0; i < n; i++){
        graf[i] = (int*)malloc(n * sizeof(int));
        for(int j = 0; j < n; j++)
            graf[i][j] = 0;
    }

    scanf("%d", &k);
    for(int i = 0; i < k; i++){
        scanf("%d%d", &a, &b);
        graf[a][b] = 1;
        graf[b][a] = 1;
    }

    k = 0;

    for(int i = 0; i < n - 1; i++){
        for(int j = i + 1; j < n; j++){
            veze[k].u = i;
            veze[k].v = j;
            if(graf[i][j] == 1)
                veze[k].rastojanje = 0;
            else
                veze[k].rastojanje = rastojanje(gradovi[i], gradovi[j]);
            k++;
        }
    }

    double rez = mst(veze, n);
    printf("%.2lf\n", rez);

    free(gradovi);
    free(veze);

    return 0;
}